/*
sample2.c

OpenMOMf[^쐬CuATvvO No.2

RpC+s:
Windows + VC++:
> cl /Ox sample2.c omm_datalib.c
> sample2.exe
Linux + gcc:
$ gcc -O sample2.c omm_datalib.c -o sample2
$ ./sample2
*/

#include "omm_datalib.h"

int main(void)
{
	const double ha = 25e-3;   // Aei[m]
	const double lx = 50e-3;   // OEhX[m]
	const double ly = 50e-3;   // OEhY[m]
	const double lz = 25e-3;   // OEhZ[m]
	const int nx = 10;         // OEhX
	const int ny = 10;         // OEhY
	const int nz = 5;          // OEhZ
	const double freq1 = 2e9;  // Jng[Hz]
	const double freq2 = 4e9;  // Ig{Hz]
	const int fdiv = 4;        // g
	const char title[] = "sample2";
	const char fnout[] = "sample2.omm";

	// initialize

	omm_init();

	// title

	omm_title(title);

	// geometry

	omm_geometry_zline(0, ha / 10, 0, 0, 1);  // feed
	omm_feed(1, 0);

	omm_geometry_zline(ha / 10, ha, 0, 0, 9);  // monopole

	omm_geometry_box(1, -lx / 2, +lx / 2, -ly / 2, +ly / 2, 0, -lz, nx, ny, nz);  // ground

	// frequency

	omm_frequency(freq1, freq2, fdiv);

	// current distribution

	//omm_plotcurrent(1, 1);

	// frequency char.

	//omm_plotsmith();
	//omm_plotzin(1, 0, 0, 0);
	//omm_plotyin(1, 0, 0, 0);
	//omm_plotref(1, 0, 0, 0);

	// far0d field

	//omm_plotfar0d(90, 0, 1, 0, 0, 0);

	// far1d field

	omm_plotfar1d('X', 72, 0);

	//omm_far1dstyle(0);
	//omm_far1dcomponent(1, 0, 0);
	//omm_far1ddb(1);
	//omm_far1dscale(-30, +10, 4);

	// far2d field

	omm_plotfar2d(18, 36);

	//omm_far2dcomponent(1, 0, 0, 0, 0, 0, 0);
	//omm_far2ddb(1);
	//omm_far2dscale(-20, +10);
	//omm_far2dobj(0.5);

	// near1d field

	//omm_plotnear1d("E", +50e-3, +50e-3, 0e-3, 0e-3, -50e-3, +50e-3, 100);

	//omm_near1ddb(1);
	//omm_near1dscale(-30, +20, 5);

	// near2d field

	//omm_plotnear2d("E", 'X', 30e-3, -50e-3, +50e-3, -50e-3, +50e-3, 20, 20);

	//omm_near2ddb(1);
	//omm_near2dscale(-30, +20);
	//omm_near2dcontour(0);
	//omm_near2dobj(2);

	// window size

	//omm_window2d(600, 400, 12, 0);
	//omm_window3d(500, 500, 60, 30);

	// output

	omm_outdata(fnout);

	return 0;
}
