/*
calcNear1d.c

calculate near field on lines
*/

#include "omm.h"
#include "omm_prototype.h"

void calcNear1d(d_complex_t ****e, d_complex_t ****h)
{
	for (int n = 0; n < NNear1d; n++) {
		for (int ifreq = 0; ifreq < NFrequency; ifreq++) {
			double kwave = (2 * PI * Frequency[ifreq]) / C;
			int i;
#ifdef _OPENMP
#pragma omp parallel for
#endif
			for (i = 0; i <= Near1d[n].div; i++) {
				// position
				double pos[3];
				double ai = (double)i / Near1d[n].div;
				for (int k = 0; k < 3; k++) {
					pos[k] = ((1 - ai) * Near1d[n].pos[0][k]) + (ai * Near1d[n].pos[1][k]);
				}

				// E/H
				nearfield(pos, ifreq, kwave, Near1dNoinc, e[n][ifreq][i], h[n][ifreq][i]);
			}
		}
	}
}
