/*
calcNear2d.c

calculate near field on planes
*/

#include "omm.h"
#include "omm_prototype.h"

// get position
void posNear2d(near2d_t data, int i, int j, double pos[3])
{
	double ai = (double)i / data.div1;
	double aj = (double)j / data.div2;

	double p0 = data.pos0;
	double p1 = ((1 - ai) * data.pos1[0]) + (ai * data.pos1[1]);
	double p2 = ((1 - aj) * data.pos2[0]) + (aj * data.pos2[1]);

	if      (data.dir == 'X') {
		// Y-Z
		pos[0] = p0;
		pos[1] = p1;
		pos[2] = p2;
	}
	else if (data.dir == 'Y') {
		// X-Z
		pos[0] = p1;
		pos[1] = p0;
		pos[2] = p2;
	}
	else if (data.dir == 'Z') {
		// X-Y
		pos[0] = p1;
		pos[1] = p2;
		pos[2] = p0;
	}
}

void calcNear2d(d_complex_t *****e, d_complex_t *****h)
{
	for (int n = 0; n < NNear2d; n++) {
		for (int ifreq = 0; ifreq < NFrequency; ifreq++) {
			double kwave = (2 * PI * Frequency[ifreq]) / C;
			int i;
#ifdef _OPENMP
#pragma omp parallel for
#endif
			for (    i = 0; i <= Near2d[n].div1; i++) {
			for (int j = 0; j <= Near2d[n].div2; j++) {
				double pos[3];
				posNear2d(Near2d[n], i, j, pos);
				nearfield(pos, ifreq, kwave, Near2dNoinc, e[n][ifreq][i][j], h[n][ifreq][i][j]);
			}
			}
		}
	}
}
