/*
logNear2d.c

write near2d.log
*/

#include "omm.h"
#include "complex.h"
#include "omm_prototype.h"

void logNear2d(d_complex_t *****e, d_complex_t *****h)
{
	FILE *fp;
	if ((fp = fopen(FN_near2d, "w")) == NULL) {
		fprintf(stderr, "*** %s open error.\n", FN_near2d);
		return;
	}

	for (int n = 0; n < NNear2d; n++) {
		char comp = Near2d[n].cmp[0];
		for (int ifreq = 0; ifreq < NFrequency; ifreq++) {
			fprintf(fp, "#%d : frequency[Hz] = %.3e\n", (n + 1), Frequency[ifreq]);
			fprintf(fp, "%s", "  No.  No.     X[m]        Y[m]        Z[m]       ");
			fprintf(fp, "%s\n", (comp == 'E')
				? "E[V/m]      Ex[V/m]   Ex[deg]    Ey[V/m]   Ey[deg]    Ez[V/m]   Ez[deg]"
				: "H[A/m]      Hx[A/m]   Hx[deg]    Hy[A/m]   Hy[deg]    Hz[A/m]   Hz[deg]");

			for (int i = 0; i <= Near2d[n].div1; i++) {
			for (int j = 0; j <= Near2d[n].div2; j++) {
				double pos[3];
				posNear2d(Near2d[n], i, j, pos);

				d_complex_t *c = (comp == 'E') ? e[n][ifreq][i][j] : h[n][ifreq][i][j];

				fprintf(fp, "%5d%5d%12.3e%12.3e%12.3e%12.4e%12.4e%9.3f%12.4e%9.3f%12.4e%9.3f\n",
					i, j, pos[0], pos[1], pos[2],
					sqrt(d_norm(c[0]) + d_norm(c[1]) + d_norm(c[2])),
					d_abs(c[0]), d_deg(c[0]), d_abs(c[1]), d_deg(c[1]), d_abs(c[2]), d_deg(c[2]));
			}
			}
		}
	}

	fclose(fp);
}
