/*
plot2dCurrent.c

plot current distribution (2D)
*/

#include "omm.h"
#include "complex.h"
#include "ev.h"

void plot2dCurrent()
{
	char str[BUFSIZ];
	const double fmin = 0;
	const double amin = -180;
	const double amax = +180;

	// layout
	double x1 = 0.12 * Width2d;
	double x2 = 0.92 * Width2d;
	double y1 = 0.10 * Height2d;
	double y2 = 0.90 * Height2d;
	int h = Font2d;

	double dx = (x2 - x1) / NElement;

	// loop on frequency

	for (int ifreq = 0; ifreq < NFrequency; ifreq++) {
		d_complex_t *c = &Cv[ifreq * NElement];
		double py1;

		// min, max
		double fmax = 0;
		for (int n = 0; n < NElement; n++) {
			fmax = MAX(fmax, d_abs(c[n]));
		}
		double exp = pow(10, floor(log10(fmax)));
		int dec = (int)((ceil)(fmax / exp));
		fmax = dec * exp;
		//printf("%f %f\n", exp, fmax);

		// plot
		ev2d_newPage();

		// grid
		ev2dlib_grid(x1, y1, x2, y2, 10, dec);

		// amplitude
		py1 = y1;
		for (int n = 0; n < NElement; n++) {
			double px1 = x1 + (n + 0) * dx;
			double px2 = x1 + (n + 1) * dx;
			double f = MAX(fmin, MIN(fmax, d_abs(c[n])));
			double py2 = y1 + (y2 - y1) * (f - fmin) / (fmax - fmin);
			if (n > 0) ev2d_drawLine(px1, py1, px1, py2);
			ev2d_drawLine(px1, py2, px2, py2);
			py1 = py2;
		}
		ev2d_drawString(x2 - 9.0 * h, y2 + 0.5 * h, h, "I[mA]");

		// phase
		ev2d_setColor(255, 0, 0);
		py1 = y1;
		for (int n = 0; n < NElement; n++) {
			double px1 = x1 + (n + 0) * dx;
			double px2 = x1 + (n + 1) * dx;
			double f = MAX(amin, MIN(amax, d_deg(c[n])));
			double py2 = y1 + (y2 - y1) * (f - amin) / (amax - amin);
			if (n > 0) ev2d_drawLine(px1, py1, px1, py2);
			ev2d_drawLine(px1, py2, px2, py2);
			py1 = py2;
		}
		ev2d_drawString(x2 - 5.0 * h, y2 + 0.5 * h, h, "I[deg]");
		ev2d_setColor(0, 0, 0);

		// feed
		const double dh = 0.3* h;
		for (int n = 0; n < NElement; n++) {
			if (Element[n].ifeed) {
				double x = x1 + (n + 0.5) * dx;
				ev2d_fillRectangle(x - dh, y1 - dh, x + dh, y1 + dh);
			}
		}

		// comment
		ev2d_drawString(x1 + 1.0 * h, y2 + 0.6 * h, h, Title);
		ev2d_drawString(x1 + 1.0 * h, y2 + 1.6 * h, h, "current distribution");

		sprintf(str, "frequency=%.3e[Hz]", Frequency[ifreq]);
		ev2d_drawString(x2 - 17.0 * h, y2 + 1.6 * h, h, str);

		// X-axis
		sprintf(str, "%d", NElement);
		ev2dlib_Xaxis(x1, x2, y1, h, "0", str, "element number");

		// left Y-axis
		sprintf(str, "%d", (int)(fmax * 1e3));
		ev2dlib_Yaxis(y1, y2, x1, h, "0", str, "");

		// right Y-axis
		ev2d_setColor(255, 0, 0);
		ev2d_drawString(x2 + 0.3 * h, y1 - 0.3 * h, h, "-180");
		ev2d_drawString(x2 + 0.3 * h, (y1 + y2) / 2 - 0.3 * h, h, "0");
		ev2d_drawString(x2 + 0.3 * h, y2 - 0.3 * h, h, "+180");
		ev2d_setColor(0, 0, 0);
	}
}
