/*
plot2dNear1d.c

plot near line field (2D)
*/

#include "omm.h"
#include "complex.h"
#include "omm_prototype.h"

void plot2dNear1d(d_complex_t ****e, d_complex_t ****h)
{
	double *amp[3], *deg[3], *lng;

	for (int n = 0; n < NNear1d; n++) {
		// alloc
		for (int m = 0; m < 3; m++) {
			amp[m] = (double *)malloc((Near1d[n].div + 1) * sizeof(double));
			deg[m] = (double *)malloc((Near1d[n].div + 1) * sizeof(double));
		}
		lng = (double *)malloc((Near1d[n].div + 1) * sizeof(double));
		for (int i = 0; i <= Near1d[n].div; i++) {
			lng[i] = (double)i / Near1d[n].div;
		}

		for (int ifreq = 0; ifreq < NFrequency; ifreq++) {
			// field
			for (int m = 0; m < 3; m++) {
				for (int i = 0; i <= Near1d[n].div; i++) {
					d_complex_t f = (Near1d[n].cmp[0] == 'E') ? e[n][ifreq][i][m] : h[n][ifreq][i][m];
					amp[m][i] = d_abs(f);
					deg[m][i] = d_deg(f);
				}
			}

			// plot
			plot2dNear1d0(
				Near1d[n].cmp, Near1d[n].div, amp, deg, lng,
				Near1dScale.db, Near1dScale.user, Near1dScale.min, Near1dScale.max, Near1dScale.div,
				Title, Frequency[ifreq], Near1d[n].pos,
				Width2d, Height2d, Font2d);
		}

		// free
		for (int m = 0; m < 3; m++) {
			free(amp[m]);
			free(deg[m]);
		}
		free(lng);
	}
}
