/*
plot3dGeom.c

plot geometry 3D
*/

#include "omm.h"
#include "ev.h"

void plot3dGeom(int ev)
{
	// initialize
	ev3d_init(Width3d, Height3d);

	// new page
	ev3d_newPage();

	// wire elements
	for (int ie = 0; ie < NElement; ie++) {
		element_t *e = &Element[ie];
		if      (e->ifeed) {
			ev3d_setColor(255, 0, 0);
		}
		else if (e->iload) {
			ev3d_setColor(0, 255, 0);
		}
		else {
			ev3d_setColor(0, 0, 0);
		}
		double x1 = e->pos[1][0];
		double y1 = e->pos[1][1];
		double z1 = e->pos[1][2];
		double x2 = e->pos[2][0];
		double y2 = e->pos[2][1];
		double z2 = e->pos[2][2];
		ev3d_drawLine(x1, y1, z1, x2, y2, z2);

		// node
		if ((cGeom3d > 0) && ((e->wire && pGeom3d[0]) || (!e->wire && pGeom3d[1]))) {
			double dh = cGeom3d * e->lng[0];
			ev3d_setColor(0, 0, 0);
			for (int k = 1; k <= 2; k++) {
				double x = e->pos[k][0];
				double y = e->pos[k][1];
				double z = e->pos[k][2];
				ev3d_drawBox(x - dh, y - dh, z - dh, x + dh, y + dh, z + dh);
			}
		}
	}

	// title
	char str[BUFSIZ];
	ev3d_setColor(0, 0, 0);
	ev3d_drawTitle(Font3d, Title);
	sprintf(str, "No. of geometries = %d", NGeometry);
	ev3d_drawTitle(Font3d, str);
	sprintf(str, "No. of elements = %d", NElement);
	ev3d_drawTitle(Font3d, str);

	// output
	if(!ev) ev3d_setAngle(Theta3d, Phi3d);
	ev3d_file(ev, (ev ? FN_geom3d_1 : FN_geom3d_0), 0);
	ev3d_output();
}
