/*
readout.c
*/

#include "omm.h"

void readout(FILE *fp)
{
	size_t sz;

	sz = fread(Title,       sizeof(char),        256,                   fp);
	sz = fread(&NElement,   sizeof(int),         1,                     fp);
	sz = fread(&NFrequency, sizeof(int),         1,                     fp);
	sz = fread(&NFeed,      sizeof(int),         1,                     fp);
	sz = fread(&Z0,         sizeof(double),      1,                     fp);

	// alloc
	Element   =   (element_t *)malloc(NElement              * sizeof(element_t));
	Frequency =      (double *)malloc(NFrequency            * sizeof(double));
	Cv        = (d_complex_t *)malloc(NFrequency * NElement * sizeof(d_complex_t));
	Zin       = (d_complex_t *)malloc(NFeed * NFrequency    * sizeof(d_complex_t));

	sz = fread(Element,     sizeof(element_t),   NElement,              fp);
	sz = fread(Frequency,   sizeof(double),      NFrequency,            fp);
	sz = fread(Cv,          sizeof(d_complex_t), NFrequency * NElement, fp);
	sz = fread(Zin,         sizeof(d_complex_t), NFeed * NFrequency,    fp);

	sz = sz;  // suppress gcc warning
}
