/*
writeout.c
*/

#include "omm.h"

void writeout(FILE *fp)
{
	fwrite(Title,       sizeof(char),        256,                   fp);
	fwrite(&NElement,   sizeof(int),         1,                     fp);
	fwrite(&NFrequency, sizeof(int),         1,                     fp);
	fwrite(&NFeed,      sizeof(int),         1,                     fp);
	fwrite(&Z0,         sizeof(double),      1,                     fp);
	fwrite(Element,     sizeof(element_t),   NElement,              fp);
	fwrite(Frequency,   sizeof(double),      NFrequency,            fp);
	fwrite(Cv,          sizeof(d_complex_t), NFrequency * NElement, fp);
	fwrite(Zin,         sizeof(d_complex_t), NFeed * NFrequency,    fp);

	// free
	//free(Element);
	//free(Frequency);
	//free(Cv);
	//free(Zin);
}
