/*
plot3dCurrent.c

plot current distribution (3D)
*/

#include "omm.h"
#include "complex.h"
#include "ev.h"

void plot3dCurrent(void)
{
	char str[BUFSIZ];

	for (int ifreq = 0; ifreq < NFrequency; ifreq++) {
		double cmax = 0;
		for (int n = 0; n < NElement; n++) {
			cmax = MAX(cmax, d_abs(Cv[(ifreq * NElement) + n]));
		}

		ev3d_newPage();

		for (int n = 0; n < NElement; n++) {
			double v = d_abs(Cv[(ifreq * NElement) + n]) / cmax;
			ev3d_setColorV(v, 1);
			ev3d_drawLine(Element[n].pos[1][0], Element[n].pos[1][1], Element[n].pos[1][2],
			              Element[n].pos[2][0], Element[n].pos[2][1], Element[n].pos[2][2]);
		}

		// comment
		sprintf(str, "f=%.3e[Hz] max=%.3e[A]", Frequency[ifreq], cmax);
		ev3d_setColor(0, 0, 0);
		ev3d_drawTitle(str);
	}
}
