# -*- coding: utf-8 -*-
"""
OpenMOM (Python)
Version 4.1.0
omm_post.py : post
"""

import matplotlib.pyplot as plt
import post.load_bin, post.post_data
import post.plot_current, post.plot_fchar
import post.plot_far1d, post.plot_far2d
import post.plot_near1d, post.plot_near2d

def main():

    # [0-1] 計算結果ファイルを読み込む
    fn_out = 'omm.npz'
    Ne, Nfreq, Freq, Nfeed, Iplanewave, Planewave, \
    E_posc, E_posm, E_posp, E_lng, E_tan, E_ifeed, E_feed, E_iload, E_load, \
    Iground, Title, Z0, Xc, Zin \
    = post.load_bin.load(fn_out)

    # [0-2] 入力データファイルを読み込む
    omm_in = 'python.omm'
    #omm_in = '../_tmp.omm'
    Post = post.post_data.read(omm_in)
    post.post_data.setup(Post, Nfeed, Freq)

    # [0-3] ウィンドウの大きさ他
    Post['w2d'] = [6.0, 4.0]          # width, height [inch]
    Post['w3d'] = [5.0, 5.0, 60, 30]  # width, height [inch], theta, phi [deg]
    # フォント
    plt.rcParams['font.family'] = ['sans-serif', 'serif', 'monospace', 'MS gothic', 'MS mincho'][0]  # 0/1/2/3/4
    plt.rcParams['font.size'] = 10  # fontsize [pixel]

    # [1] 電流分布図 (2D/3D)
    post.plot_current.plot(
        Post, Ne, Nfreq, Freq,
        E_posm, E_posp,
        Title, Xc)

    # [2] 周波数特性図 (2D)
    post.plot_fchar.plot(
        Post, Ne, Nfreq, Freq, Nfeed,
        E_posc, E_lng, E_tan, E_ifeed, E_feed,
        Iground, Title, Z0, Xc, Zin)

    # [3] 遠方界面内パターン図 (2D)
    post.plot_far1d.plot(
        Post, Ne, Nfreq, Freq, Nfeed,
        E_posc, E_lng, E_tan, E_ifeed, E_feed,
        Iground, Title, Z0, Xc, Zin)

    # [4] 遠方界全方向図 (3D)
    post.plot_far2d.plot(
        Post, Ne, Nfreq, Freq, Nfeed, Iplanewave, Planewave,
        E_posc, E_lng, E_tan, E_ifeed, E_feed, E_iload, E_load,
        Iground, Title, Z0, Xc, Zin)

    # [5] 近傍界線上分布図 (2D)
    post.plot_near1d.plot(
        Post, Nfreq, Freq, Nfeed, Iplanewave, Planewave,
        E_posc, E_posm, E_posp, E_lng, E_tan,
        Iground, Title, Xc)

    # [6] 近傍界面上分布図 (2D)
    post.plot_near2d.plot(
        Post, Nfreq, Freq, Nfeed, Iplanewave, Planewave,
        E_posc, E_posm, E_posp, E_lng, E_tan,
        Iground, Title, Xc)

# entry point
if __name__ == "__main__":
    main()
