# -*- coding: utf-8 -*-
"""
post_data.py
"""

# read post data
def read(fn):
    # dictionary
    Post = { \
        'mloss'      : 0, \
        'current'    : [0, 0], \
        
        'smith'      : 0, \
        'zin'        : [0, 0, 0, 0], \
        'yin'        : [0, 0, 0, 0], \
        'ref'        : [0, 0, 0, 0], \
        'f0d'        : [0, 0, 0, 0, 0, 0], \
        'freqdiv'    : 10, \
        
        'f1ddir'     : [], \
        'f1ddiv'     : [], \
        'f1dangle'   : [], \
        'f1dstyle'   : 0, \
        'f1dcompo'   : [1, 0, 0], \
        'f1ddb'      : 1, \
        'f1dnorm'    : 0, \
        'f1dscale'   : [0, 0, 0, 0], \
        
        'f2d'        : [0, 0, 0], \
        'f2dcompo'   : [1, 0, 0, 0, 0, 0, 0], \
        'f2ddb'      : 1, \
        'f2dscale'   : [0, 0, 30], \
        'f2dobj'     : 0,  # not used \
        
        'n1dcompo'   : [], \
        'n1dposx'    : [], \
        'n1dposy'    : [], 
        'n1dposz'    : [], \
        'n1ddiv'     : [], \
        'n1ddb'      : 0, \
        'n1dscale'   : [0, 0, 0, 0], \
        'n1dnoinc'   : 0, \
        
        'n2ddim'     : [1, 0],  # not used \
        'n2dcompo'   : [], \
        'n2ddir'     : [], \
        'n2dpos'     : [], \
        'n2ddiv'     : [], \
        'n2dscale'   : [0, 0, 0, 20],  # (4) new \
        'n2dframe'   : 0,  # not used \
        'n2ddb'      : 0, \
        'n2dnoinc'   : 0, \
        'n2dcontour' : 0, \
        'n2dobj'     : 1}
    
    # read file
    with open(fn, 'rt', encoding='utf-8') as fp:
        header = fp.readline()
        lines = fp.readlines()

    # header
    d = header.strip().split()
    if (len(d) < 3) or (d[0] != 'OpenMOM'):
        print('Not OpenMOM data.')
        return
    version = (100 * int(d[1])) + int(d[2])
    if version < 301:
        print('*** version of data is old : %s.%s < 3.1' % (d[1], d[2]))
        return

    # body
    for tline in lines:
        # token
        d = tline.strip().split()  #;print(d)
        
        # check
        if d[0].startswith('#'):
            continue
        elif (d[0] == 'end'):
            break
        elif (len(d) < 3):
            continue
        elif (d[1] != "="):
            continue

        # parameter array (string)
        p = d[2:]
        
        # input
        key = d[0]
        if   key == 'matchingloss':
            Post['mloss'] = int(p[0])
        elif key == 'plotcurrent':
            if (len(p) > 1):
                Post['current'] = [int(p[0]), int(p[1])]
        elif key == 'plotsmith':
            Post['smith'] = int(p[0])
        elif key == 'plotzin':
            Post['zin'][0] = int(p[0])
            if (len(p) > 3):
                Post['zin'][1] = min(float(p[1]), float(p[2]))
                Post['zin'][2] = max(float(p[1]), float(p[2]))
                Post['zin'][3] = int(p[3])
        elif key == 'plotyin':
            Post['yin'][0] = int(p[0])
            if (len(p) > 3):
                Post['yin'][1] = min(float(p[1]), float(p[2]))
                Post['yin'][2] = max(float(p[1]), float(p[2]))
                Post['yin'][3] = int(p[3])
        elif key == 'plotref':
            Post['ref'][0] = int(p[0])
            if (len(p) > 3):
                Post['ref'][1] = min(float(p[1]), float(p[2]))
                Post['ref'][2] = max(float(p[1]), float(p[2]))
                Post['ref'][3] = int(p[3])
        elif key == 'plotfar0d':
            if (len(p) > 2):
                Post['f0d'][0:3] = [float(p[0]), float(p[1]), int(p[2])] #p(1:3)
                if (len(p) > 5):
                    Post['f0d'][3] = min(float(p[3]), float(p[4]))
                    Post['f0d'][4] = max(float(p[3]), float(p[4]))
                    Post['f0d'][5] = int(p[5])
        elif key == 'freqdiv':
            Post['freqdiv'] = int(p[0])
        elif key == 'plotfar1d':
            if len(p) > 1:
                Post['f1ddir'].append(p[0])  # string
                Post['f1ddiv'].append(int(p[1]))
                if len(p) > 2:
                    Post['f1dangle'].append(float(p[2]))
                else:
                    Post['f1dangle'].append(0)
        elif key == 'far1dstyle':
            Post['f1dstyle'] = int(p[0])
        elif key == 'far1dcomponent':
            if len(p) > 2:
                Post['f1dcompo'][0:3] = [int(p[0]), int(p[1]), int(p[2])]
        elif key == 'far1ddb':
            Post['f1ddb'] = int(p[0])
        elif key == 'far1dnorm':
            Post['f1dnorm'] = int(p[0])
        elif key == 'far1dscale':
            Post['f1dscale'][0] = 1
            if len(p) > 2:
                Post['f1dscale'][1] = min(float(p[0]), float(p[1]))
                Post['f1dscale'][2] = max(float(p[0]), float(p[1]))
                Post['f1dscale'][3] = int(p[2])
        elif key == 'plotfar2d':
            Post['f2d'][0] = 1
            if len(p) > 1:
                Post['f2d'][1:3] = [int(p[0]), int(p[1])]
        elif key == 'far2dcomponent':
            if len(p) > 6:
                Post['f2dcompo'] = [int(p[0]), int(p[1]), int(p[2]), int(p[3]), int(p[4]), int(p[5]), int(p[6])]
        elif key == 'far2ddb':
            Post['f2ddb'] = int(p[0])
        elif key == 'far2dscale':
            Post['f2dscale'][0] = 1
            if len(p) > 1:
                Post['f2dscale'][1:3] = [float(p[0]), float(p[1])]  # dB only
        elif key == 'far2dobj':
            Post['f2dobj'] = float(p[0])  # not used
        elif key == 'plotnear1d':
            if len(p) > 7:
                Post['n1dcompo'].append(p[0])  # string : 'E'...
                Post['n1dposx'].append([float(p[1]), float(p[2])])
                Post['n1dposy'].append([float(p[3]), float(p[4])])
                Post['n1dposz'].append([float(p[5]), float(p[6])])
                Post['n1ddiv'].append(int(p[7]))
        elif key == 'near1ddb':
            Post['n1ddb'] = int(p[0])
        elif key == 'near1dscale':
            Post['n1dscale'][0] = 1
            if len(p) > 2:
                Post['n1dscale'][1] = min(float(p[0]), float(p[1]))
                Post['n1dscale'][2] = max(float(p[0]), float(p[1]))
                Post['n1dscale'][3] = int(p[2])
        elif key == 'near1dnoinc':
            Post['n1dnoinc'] = int(p[0])
        elif key == 'plotnear2d':
            if len(p) > 8:
                Post['n2dcompo'].append(p[0])  # string : 'E'...
                Post['n2ddir'].append(p[1])    # string : 'X'...
                Post['n2dpos'].append([float(p[2]), float(p[3]), float(p[4]), float(p[5]), float(p[6])])
                Post['n2ddiv'].append([int(p[7]), int(p[8])])
        elif key == 'near2ddim':
            if len(p) > 1:
                Post['n2ddim'] = [int(p[0]), int(p[1])]  # not used
        elif key == 'near2dframe':
            Post['n2dframe'] = int(p[0])  # not used
        elif key == 'near2ddb':
            Post['n2ddb'] = int(p[0])
        elif key == 'near2dscale':
            Post['n2dscale'][0] = 1
            if len(p) > 1:
                Post['n2dscale'][1] = min(float(p[0]), float(p[1]))
                Post['n2dscale'][2] = max(float(p[0]), float(p[1]))
            if len(p) > 2:
                Post['n2dscale'][3] = int(p[2])
        elif key == 'near2dnoinc':
            Post['n2dnoinc'] = int(p[0])
        elif key == 'near2dcontour':
            Post['n2dcontour'] = int(p[0])
        elif key == 'near2dobj':
            Post['n2dobj'] = int(p[0])

    return Post

def setup(Post, Nfeed, Freq):
    # frequency band
    freq0 = (Freq[0] + Freq[-1]) / 2
    if   freq0 > 1e12:
        fscale = 1e-12
        funit = '[THz]'
    elif freq0 > 1e9:
        fscale = 1e-9
        funit = '[GHz]'
    elif freq0 > 1e6:
        fscale = 1e-6
        funit = '[MHz]'
    elif freq0 > 1e3:
        fscale = 1e-3
        funit = '[kHz]'
    else:
        fscale = 1
        funit = '[Hz]'

    Post['fscale'] = fscale
    Post['funit'] = funit

    # far field component
    Post['farcomp'] = ['E-abs', 'E-theta', 'E-phi', 'E-major', 'E-minor', 'E-RHCP', 'E-LHCP']

    # far field name
    if Nfeed > 0:
        Post['farname'] = 'gain'
    else:
        Post['farname'] = 'cross section'

    # far field unit
    Post['f0dunit'] = ''
    Post['f1dunit'] = ''
    Post['f2dunit'] = ''
    if Nfeed > 0:
        Post['f0dunit'] = '[dBi]'  # dB only
        if Post['f1ddb'] == 1:
            Post['f1dunit'] = '[dBi]' if Post['f1dnorm'] == 0 else '[dB]'
        if Post['f2ddb'] == 1:
            Post['f2dunit'] = '[dBi]'
    else:
        Post['f0dunit'] = '[dBm^2]'  # dB only
        if Post['f1ddb'] == 1:
            Post['f1dunit'] = '[dBm^2]' if Post['f1dnorm'] == 0 else '[dB]'
        else:
            Post['f1dunit'] = '[m^2]' if Post['f1dnorm']== 0 else ''
        if Post['f2ddb'] == 1:
            Post['f2dunit'] = '[dBm^2]'
        else:
            Post['f2dunit'] = '[m^2]'
