/*
outputomm.c

output OpenMOM datafile
*/

#include "omm.h"

void outputomm(const char fn[], double r)
{
	const char program[] = "OpenMOM 4 0";

	// open
	FILE *fp;
	if ((fp = fopen(fn, "w")) == NULL) {
		fprintf(stderr, "file %s open error.\n", fn);
		exit(1);
	}

	// header
	fprintf(fp, "%s\n", program);
	//fprintf(fp, "title = OpenMOM optimization\n");

	// geometry
	assert(NGeometry > 0);
	for (int n = 0; n < NGeometry; n++) {
		fprintf(fp, "geometry = 1 1 %g %g %g %g %g %g %d\n",  // wire XYZ
			Geometry[n].pos[0][0], Geometry[n].pos[1][0],
			Geometry[n].pos[0][1], Geometry[n].pos[1][1],
			Geometry[n].pos[0][2], Geometry[n].pos[1][2], Geometry[n].div[0]);
		if (Geometry[n].ifeed) {
			fprintf(fp, "feed = %g %g\n", Geometry[n].feed[0], Geometry[n].feed[1]);
		}
		if (Geometry[n].iload) {
			fprintf(fp, "load = %d %g\n", Geometry[n].iload, Geometry[n].load);
		}
		if ((Geometry[n].offset[0] != 0) || (Geometry[n].offset[1] != 0) || (Geometry[n].offset[2] != 0)) {
			fprintf(fp, "offset = %g %g %g\n", Geometry[n].offset[0], Geometry[n].offset[1], Geometry[n].offset[2]);
		}
/*
		if (Geometry[n].iradius) {
			fprintf(fp, "radius = %g\n", Geometry[n].radius);
		}
*/
	}

	// misc.
	assert(NFrequency > 0);
	fprintf(fp, "radiusall = 1 %g\n", r);
	fprintf(fp, "frequency = %g %g %d\n", Frequency[0], Frequency[NFrequency - 1], NFrequency - 1);
	if (IGround) {
		fprintf(fp, "ground = %d\n", IGround);
	}
	fprintf(fp, "z0 = %g\n", Z0);

	// tailor
	fprintf(fp, "end\n");

	fclose(fp);
}
