/*
OpenMOM Version 4.1.1

post process
*/

#define MAIN
#include "omm.h"
#undef MAIN

#include "omm_prototype.h"

static void args(int, char *[], int *, int *, char []);

int main(int argc, char *argv[])
{
	const char errfmt[] = "*** file %s open error.\n";
	FILE *fp_in = NULL, *fp_out = NULL;

	// arguments
	HTML = 0;
	int nthread = 1;
	int prompt = 0;
	char fn_in[BUFSIZ] = "";
	args(argc, argv, &nthread, &prompt, fn_in);

	// set number of threads
#ifdef _OPENMP
	omp_set_num_threads(nthread);
#else
	nthread = 1;
#endif

	// input data
	if ((fp_in = fopen(fn_in, "r")) == NULL) {
		fprintf(stderr, errfmt, fn_in);
		exit(1);
	}
	if (post_data(fp_in)) {
		exit(1);
	}
	fclose(fp_in);

	// read omm.out
	if ((fp_out = fopen(FN_out, "rb")) == NULL) {
		printf(errfmt, FN_out);
		exit(1);
	}
	readout(fp_out);
	fclose(fp_out);

	// post process
	post();

	// free (1)
	//memfree(1, nthread, simd);

	// prompt
	if (prompt) getchar();

	return 0;
}

static void args(int argc, char *argv[],
	int *nthread, int *prompt, char fn_in[])
{
	const char usage[] = "Usage : omm_post [-n <thread>] [-html] <datafile>";

	if (argc < 2) {
		printf("%s\n", usage);
		exit(0);
	}

	while (--argc) {
		++argv;
		if (!strcmp(*argv, "-n")) {
			if (--argc) {
				*nthread = atoi(*++argv);
				if (*nthread <= 0) *nthread = 1;
			}
			else {
				break;
			}
		}
		else if (!strcmp(*argv, "-html")) {
			HTML = 1;
		}
		else if (!strcmp(*argv, "-prompt")) {
			*prompt = 1;
		}
		else if (!strcmp(*argv, "--help")) {
			printf("%s\n", usage);
			exit(0);
		}
		else if (!strcmp(*argv, "--version")) {
			printf("%s Ver.%d.%d.%d\n", PROGRAM, VERSION_MAJOR, VERSION_MINOR, VERSION_BUILD);
			exit(0);
		}
		else {
			strcpy(fn_in, *argv);
		}
	}
}
