/*
calcNear1d.c

calculate near field on lines
*/

#include "omm.h"
#include "omm_prototype.h"


// get position
void posNear1d(near1d_t data, int i, double pos[])
{
	const double ai = (double)i / data.div;

	for (int k = 0; k < 3; k++) {
		pos[k] = (1 - ai) * data.pos[0][k]
		       + (    ai) * data.pos[1][k];
	}
}


void calcNear1d(d_complex_t ****e, d_complex_t ****h)
{
	for (int n = 0; n < NNear1d; n++) {
		for (int ifreq = 0; ifreq < NFrequency; ifreq++) {
			const double kwave = (2 * PI * Frequency[ifreq]) / C;
			int i;
#ifdef _OPENMP
#pragma omp parallel for
#endif
			for (i = 0; i <= Near1d[n].div; i++) {
				double pos[3];
				posNear1d(Near1d[n], i, pos);
				nearfield(pos, ifreq, kwave, Near1dNoinc, e[n][ifreq][i], h[n][ifreq][i]);
			}
		}
	}
}
