/*
outputNear1d.c

output near field on lines
*/

#include "omm.h"
#include "omm_prototype.h"

void outputNear1d()
{
	// alloc
	d_complex_t ****e = (d_complex_t ****)malloc(NNear1d * sizeof(d_complex_t ***));
	d_complex_t ****h = (d_complex_t ****)malloc(NNear1d * sizeof(d_complex_t ***));
	for (int n = 0; n < NNear1d; n++) {
		e[n] = (d_complex_t ***)malloc(NFrequency * sizeof(d_complex_t **));
		h[n] = (d_complex_t ***)malloc(NFrequency * sizeof(d_complex_t **));
		for (int ifreq = 0; ifreq < NFrequency; ifreq++) {
			e[n][ifreq] = (d_complex_t **)malloc((Near1d[n].div + 1) * sizeof(d_complex_t *));
			h[n][ifreq] = (d_complex_t **)malloc((Near1d[n].div + 1) * sizeof(d_complex_t *));
			for (int i = 0; i <= Near1d[n].div; i++) {
				e[n][ifreq][i] = (d_complex_t *)malloc(3 * sizeof(d_complex_t));
				h[n][ifreq][i] = (d_complex_t *)malloc(3 * sizeof(d_complex_t));
			}
		}
	}

	// calculation
	calcNear1d(e, h);

	// plot
	plot2dNear1d(e, h);

	// write log
	logNear1d(e, h);

	// free
	for (int n = 0; n < NNear1d; n++) {
		for (int ifreq = 0; ifreq < NFrequency; ifreq++) {
			for (int i = 0; i <= Near1d[n].div; i++) {
				free(e[n][ifreq][i]);
				free(h[n][ifreq][i]);
			}
			free(e[n][ifreq]);
			free(h[n][ifreq]);
		}
		free(e[n]);
		free(h[n]);
	}
	free(e);
	free(h);
}
