/*
outputNear2d.c

output near field on planes
*/

#include "omm.h"
#include "omm_prototype.h"


void outputNear2d(void)
{
	// alloc
	d_complex_t *****e = (d_complex_t *****)malloc(NNear2d * sizeof(d_complex_t ****));
	d_complex_t *****h = (d_complex_t *****)malloc(NNear2d * sizeof(d_complex_t ****));
	for (int n = 0; n < NNear2d; n++) {
		e[n] = (d_complex_t ****)malloc(NFrequency * sizeof(d_complex_t ***));
		h[n] = (d_complex_t ****)malloc(NFrequency * sizeof(d_complex_t ***));
		for (int ifreq = 0; ifreq < NFrequency; ifreq++) {
			e[n][ifreq] = (d_complex_t ***)malloc((Near2d[n].div1 + 1) * sizeof(d_complex_t **));
			h[n][ifreq] = (d_complex_t ***)malloc((Near2d[n].div1 + 1) * sizeof(d_complex_t **));
			for (int i = 0; i <= Near2d[n].div1; i++) {
				e[n][ifreq][i] = (d_complex_t **)malloc((Near2d[n].div2 + 1) * sizeof(d_complex_t *));
				h[n][ifreq][i] = (d_complex_t **)malloc((Near2d[n].div2 + 1) * sizeof(d_complex_t *));
				for (int j = 0; j <= Near2d[n].div2; j++) {
					e[n][ifreq][i][j] = (d_complex_t *)malloc(3 * sizeof(d_complex_t));
					h[n][ifreq][i][j] = (d_complex_t *)malloc(3 * sizeof(d_complex_t));
				}
			}
		}
	}

	// calculation
	calcNear2d(e, h);

	// plot
	plot2d3dNear2d(e, h);

	// write log
	logNear2d(e, h);

	// free
	for (int n = 0; n < NNear2d; n++) {
		for (int ifreq = 0; ifreq < NFrequency; ifreq++) {
			for (int i = 0; i <= Near2d[n].div1; i++) {
				for (int j = 0; j <= Near2d[n].div2; j++) {
					free(e[n][ifreq][i][j]);
					free(h[n][ifreq][i][j]);
				}
				free(e[n][ifreq][i]);
				free(h[n][ifreq][i]);
			}
			free(e[n][ifreq]);
			free(h[n][ifreq]);
		}
		free(e[n]);
		free(h[n]);
	}
	free(e);
	free(h);
}
