/*
plot2dFreq.c

plot frequency char.s (2D)
*/

#include "omm.h"
#include "omm_prototype.h"

void plot2dFreq()
{
	const int nfeed = NFeed;
	const int nfreq = NFrequency;
	const double *freq = Frequency;

	// alloc
	double *z0 = (double *)malloc(nfeed * sizeof(double));
	for (int ifeed = 0; ifeed < nfeed; ifeed++) {
		z0[ifeed] = Z0;
	}

	// (1) Smith Chart

	if (IFreq[0] && nfeed && nfreq) {
		plot2dSmith(nfeed, nfreq, Zin, z0, freq, Title, Width2d, Height2d, Fontsize2d);
	}

	// (2) Zin

	if (IFreq[1] && nfeed && nfreq) {
		plot2dZin(nfeed, nfreq, Zin, FreqScale[1], Freqdiv, freq, Title, Width2d, Height2d, Fontsize2d);
	}

	// (3) Yin

	if (IFreq[2] && nfeed && nfreq) {
		plot2dYin(nfeed, nfreq, Zin, FreqScale[2], Freqdiv, freq, Title, Width2d, Height2d, Fontsize2d);
	}

	// (4) reflection

	if (IFreq[3] && nfeed && nfreq) {
		plot2dRef(nfeed, nfreq, Zin, z0, FreqScale[3], Freqdiv, freq, Title, Width2d, Height2d, Fontsize2d);
	}

	// free
	free(z0);
}
