/*
post.c

post process
*/

#include "omm.h"
#include "ev.h"
#include "omm_prototype.h"

static void geometrylines(void);

void post(void)
{
	ev2d_init(Width2d, Height2d);

	ev3d_init();

	if (NFar2d || NNear2d) {
		geometrylines();
	}

	if (Pcurrent[0]) {
		plot2dCurrent();
	}
	if (Pcurrent[1]) {
		plot3dCurrent();
	}

	if (IFreq[0] || IFreq[1] || IFreq[2] || IFreq[3]) {
		plot2dFreq();
	}

	if (IFar0d) {
		outputFar0d();
	}

	if (NFar1d) {
		outputFar1d();
	}

	if (NFar2d) {
		outputFar2d();
	}

	if (NNear1d) {
		outputNear1d();
	}

	if (NNear2d) {
		outputNear2d();
	}

	ev2d_file(!HTML, (!HTML ? FN_ev2d_1 : FN_ev2d_0));
	ev2d_output();

	ev3d_file(!HTML, (!HTML ? FN_ev3d_1 : FN_ev3d_0), 0);
	ev3d_output();
}

// geometry lines
static void geometrylines(void)
{
	int ngline = 0;
	for (int ie = 0; ie < NElement; ie++) {
		if (Element[ie].border) {
			ngline++;
		}
	}
	NGline = ngline;

	if (NGline > 0) {
		Gline = (double (*)[2][3])malloc(NGline * 2 * 3 * sizeof(double));
		ngline = 0;
		for (int ie = 0; ie < NElement; ie++) {
			if (Element[ie].border) {
				for (int m = 0; m < 3; m++) {
					Gline[ngline][0][m] = Element[ie].pos[1][m];
					Gline[ngline][1][m] = Element[ie].pos[2][m];
				}
				ngline++;
			}
		}
	}
}
