/*
readout.c

read omm.out
*/

#include "omm.h"

void readout(FILE *fp)
{
	size_t num = 0;

	num += fread(Title,       sizeof(char),        256,                   fp);
	num += fread(&NElement,   sizeof(int),         1,                     fp);
	num += fread(&NFrequency, sizeof(int),         1,                     fp);
	num += fread(&NFeed,      sizeof(int),         1,                     fp);
	num += fread(&IPlanewave, sizeof(int),         1,                     fp);
	num += fread(&IGround,    sizeof(int),         1,                     fp);
	num += fread(&Z0,         sizeof(double),      1,                     fp);
	num += fread(&Planewave,  sizeof(planewave_t), 1,                     fp);

	// alloc
	Element   =   (element_t *)malloc(NElement              * sizeof(element_t));
	Frequency =      (double *)malloc(NFrequency            * sizeof(double));
	Cv        = (d_complex_t *)malloc(NFrequency * NElement * sizeof(d_complex_t));
	Zin       = (d_complex_t *)malloc(NFeed * NFrequency    * sizeof(d_complex_t));

	num += fread(Element,     sizeof(element_t),   NElement,              fp);
	num += fread(Frequency,   sizeof(double),      NFrequency,            fp);
	num += fread(Cv,          sizeof(d_complex_t), NFrequency * NElement, fp);
	num += fread(Zin,         sizeof(d_complex_t), NFeed * NFrequency,    fp);

	size_t num0;
	size_t size = fread(&num0, sizeof(size_t), 1, fp);
	size = size;  // suppress gcc warning
	//printf("%zd %zd\n", num, num0);

	if (num != num0) {
		fprintf(stderr, "*** invalid file length : (%zd, %zd)\n", num0, num);
	}
}
