# -*- coding: utf-8 -*-
# monitor.py

import sys
import datetime
import numpy as np

EPS = 1e-10

def monitor1(fp, msg):
    monitor1_(fp,         msg)
    monitor1_(sys.stdout, msg)

def monitor2(fp, c_dtype, Title, Ngeom, Ne, Nfreq, Nfeed, Nload, Iplanewave, Iground):
    monitor2_(fp,         c_dtype, Title, Ngeom, Ne, Nfreq, Nfeed, Nload, Iplanewave, Iground)
    monitor2_(sys.stdout, c_dtype, Title, Ngeom, Ne, Nfreq, Nfeed, Nload, Iplanewave, Iground)

def monitor3(fp, Nfreq, Freq, Nfeed, Z0, Zin, Rcs):
    monitor3_(fp,         Nfreq, Freq, Nfeed, Z0, Zin, Rcs)
    monitor3_(sys.stdout, Nfreq, Freq, Nfeed, Z0, Zin, Rcs)

def monitor4(fp):
    monitor4_(fp)
    monitor4_(sys.stdout)

def monitor5(fp, cpu):
    monitor5_(fp,         cpu)
    monitor5_(sys.stdout, cpu)

def monitor1_(fp, msg):
    fp.write(msg + '\n')

def monitor2_(fp, c_dtype, Title, Ngeom, Ne, Nfreq, Nfeed, Nload, Iplanewave, Iground):
    strgnd = ['NO', 'YES']
    strpol = ['NO', 'V', 'H', 'RHCP', 'LHCP', 'Elliptical']
    csize = 8 if c_dtype == 'c8' else 16
    mem = (csize * Ne**2) // 1024**2 + 1

    fp.write('%s\n' % datetime.datetime.now().ctime())
    fp.write('Title = %s\n' % Title)
    fp.write('No. of geometries  = %d\n' % Ngeom)
    fp.write('No. of elements    = %d\n' % Ne)
    fp.write('No. of feeds       = %d\n' % Nfeed)
    fp.write('No. of loads       = %d\n' % Nload)
    fp.write('Ground             = %s\n' % strgnd[Iground])
    fp.write('Plane wave         = %s\n' % strpol[Iplanewave])
    fp.write('Memory size [MB]   = %d\n' % mem)
    fp.write('No. of frequencies = %d\n' % Nfreq)

def monitor3_(fp, Nfreq, Freq, Nfeed, Z0, Zin, Rcs):
    if Nfeed > 0:
        # feed
        fmt = '%13.5e%11.3f%11.3f%11.3f%11.3f%11.3f%11.3f\n'
        fp.write('=== input impedance (Z0=%.1f[ohm]) ===\n' % Z0)
        for ifeed in range(Nfeed):
            fp.write('  feed# = %d\n' % (ifeed + 1))
            fp.write('  frequency[Hz] Rin[ohm]   Xin[ohm]    Gin[mS]    Bin[mS]    Ref[dB]       VSWR\n')
            for ifreq in range(Nfreq): #= 1 : nfreq
                zin = Zin[ifeed, ifreq]
                yin = 1 / zin
                gamma = abs((zin - Z0) / (zin + Z0))
                ref = 20 * np.log10(max(gamma, EPS))
                vswr = (1 + gamma) / (1 - gamma) if (abs(1 - gamma) > EPS) else 1000
                fp.write(fmt % (Freq[ifreq], zin.real, zin.imag, yin.real * 1e3, yin.imag * 1e3, ref, vswr))
    else:
        # plane wave
        fmt = '%13.5e%16.5e%16.5e\n'
        fp.write('=== cross section ===\n')
        fp.write('  frequency[Hz] backward[m*m]    forward[m*m]\n')
        for ifreq in range(Nfreq):
            fp.write(fmt % (Freq[ifreq], Rcs[0, ifreq], Rcs[1, ifreq]))

def monitor4_(fp):
    fp.write('=== output files ===\n')
    fp.write('omm.log, element.log, current.log, omm.npz\n')

def monitor5_(fp, cpu):
    fp.write('=== normal end ===\n')
    fp.write('%s\n' % datetime.datetime.now().ctime())
    fp.write('=== cpu time [sec] ===\n')
    fp.write('part-1 : %10.3f\n' % (cpu[1] - cpu[0]))
    fp.write('part-2 : %10.3f\n' % (cpu[2] - cpu[1]))
    fp.write('part-3 : %10.3f\n' % (cpu[3] - cpu[2]))
    fp.write('part-4 : %10.3f\n' % (cpu[4] - cpu[3]))
    fp.write('-------------------\n')
    fp.write('total  : %10.3f\n' % (cpu[4] - cpu[0]))
