# -*- coding: utf-8 -*-
# output_log.py

import numpy as np

# element.log
def element(Ne, E_posc, E_lng, E_tan, E_rad):
    fn = 'element.log'
    fmt = '%6d%13.4e%13.4e%13.4e%13.4e%13.4e%13.4e%13.4e\n'

    with open(fn, 'wt', encoding='utf-8') as fp:
        fp.write('%d\n' % Ne)
        for ie in range(Ne):
            lng = E_lng[ie, 0]
            fp.write(fmt % (ie + 1, \
                E_posc[ie, 0], E_posc[ie, 1], E_posc[ie, 2], \
                lng * E_tan[ie, 0], lng * E_tan[ie, 1], lng * E_tan[ie, 2], \
                E_rad[ie]))


# current.log
def current(Ne, Nfreq, E_ifeed, E_iload, Xc):
    fn = 'current.log'
    fmt = '%6d%13.4e%9.3f%13.4e%13.4e%2d\n'

    with open(fn, 'wt', encoding='utf-8') as fp:
        fp.write('%d %d\n' % (Ne, Nfreq))
        for ifreq in range(Nfreq):
            for ie in range(Ne):
                c = Xc[ifreq, ie] * 1e3  # mA
                idx = 0  # =0/1/2/3
                if (E_ifeed[ie] > 0):
                    idx += 1
                if (E_iload[ie] > 0):
                    idx += 2
                fp.write(fmt % (ie + 1, \
                    np.abs(c), np.angle(c, True), c.real, c.imag, idx))


