/*
vector.h
*/

#ifndef _VECTOR_H_
#define _VECTOR_H_

#include <math.h>

// inner product
static inline double vector_innerprod(const double v1[3], const double v2[3])
{
	return (v1[0] * v2[0]) +
	       (v1[1] * v2[1]) +
	       (v1[2] * v2[2]);
}


// outer product
static inline void vector_outerprod(const double v1[3], const double v2[3], double v3[3])
{
	v3[0] = (v1[1] * v2[2]) - (v1[2] * v2[1]);
	v3[1] = (v1[2] * v2[0]) - (v1[0] * v2[2]);
	v3[2] = (v1[0] * v2[1]) - (v1[1] * v2[0]);
}


// length^2
static inline double vector_length2(const double v[3])
{
	return (v[0] * v[0]) +
	       (v[1] * v[1]) +
	       (v[2] * v[2]);
}


// length
static inline double vector_length(const double v[3])
{
	return sqrt((v[0] * v[0]) +
	            (v[1] * v[1]) +
	            (v[2] * v[2]));
}


// normalize
static inline void vector_normalize(const double v1[3], double v2[3])
{
	const double lv = vector_length(v1);
	if (lv > 0) {
		v2[0] = v1[0] / lv;
		v2[1] = v1[1] / lv;
		v2[2] = v1[2] / lv;
	}
	else {
		v2[0] = v2[1] = v2[2] = 0;
	}
}


// distance^2
static inline double vector_distance2(const double v1[3], const double v2[3])
{
	return (v1[0] - v2[0]) * (v1[0] - v2[0]) +
	       (v1[1] - v2[1]) * (v1[1] - v2[1]) +
	       (v1[2] - v2[2]) * (v1[2] - v2[2]);
}


// distance
static inline double vector_distance(const double v1[3], const double v2[3])
{
	return sqrt((v1[0] - v2[0]) * (v1[0] - v2[0]) +
	            (v1[1] - v2[1]) * (v1[1] - v2[1]) +
	            (v1[2] - v2[2]) * (v1[2] - v2[2]));
}


// copy, v1 <= v2
static inline void vector_copy(const double v1[3], double v2[3])
{
	v2[0] = v1[0];
	v2[1] = v1[1];
	v2[2] = v1[2];
}


// add vectors : v3 = v1 + v2
static inline void vector_add(const double v1[3], const double v2[3], double v3[3])
{
	v3[0] = v1[0] + v2[0];
	v3[1] = v1[1] + v2[1];
	v3[2] = v1[2] + v2[2];
}


// substract vectors : v3 = v1 - v2
static inline void vector_sub(const double v1[3], const double v2[3], double v3[3])
{
	v3[0] = v1[0] - v2[0];
	v3[1] = v1[1] - v2[1];
	v3[2] = v1[2] - v2[2];
}


// multiply by a scalar : v2 = s * v1
static inline void vector_mulscalar(double s, const double v1[3], double v2[3])
{
	v2[0] = s * v1[0];
	v2[1] = s * v1[1];
	v2[2] = s * v1[2];
}

#endif  // _VECTOR_H_
