/*
OpenRTM Version 1.0.1
ポスト処理
*/

#define MAIN
#include "ort.h"
#undef MAIN

#include "ort_prototype.h"

static void args(int, char *[], char []);


int main(int argc, char *argv[])
{
	const char fn_out[] = "ort.out";
	const char fn_ev2d[] = "ev.ev2";
	const char fn_ev3d[] = "ev.ev3";
	const char errfmt[] = "*** file %s open error.\n";
	FILE *fp_in, *fp_out;

	// 引数処理
	char fn_in[BUFSIZ];
	args(argc, argv, fn_in);

	// 入力ファイルを開く
	if ((fp_in = fopen(fn_in, "r")) == NULL) {
		fprintf(stderr, errfmt, fn_in);
		exit(1);
	}

	// ファイル入力
	if (post_data(fp_in)) {
		exit(1);
	}

	// 入力ファイルを閉じる
	fclose(fp_in);

	// 計算結果ファイルを開く
	if ((fp_out = fopen(fn_out, "rb")) == NULL) {
		fprintf(stderr, errfmt, fn_out);
		exit(1);
	}

	// 計算結果を読み込む
	readout(fp_out);

	// 計算結果ファイルを閉じる
	fclose(fp_out);

	// 2D図形出力
	post2d(fn_ev2d);

	// 3D図形出力
	post3d(fn_ev3d);

	return 0;
}


// 引数処理
static void args(int argc, char *argv[], char fn_in[])
{
	const char usage[] = "Usage : ort_post [-html] <datafile>";

	if (argc < 2) {
		printf("%s\n", usage);
		exit(0);
	}

	// 既定値
	HTML = 0;
	strcpy(fn_in, "");

	while (--argc) {
		++argv;
		if (!strcmp(*argv, "--help")) {
			printf("%s\n", usage);
			exit(0);
		}
		else if (!strcmp(*argv, "-html")) {
			HTML = 1;
		}
		else {
			strcpy(fn_in, *argv);
		}
	}
}
