/*
plot3dPath.c
伝搬経路図形出力(3D)
*/

#include "ort.h"
#include "ort_prototype.h"
#include "ev.h"


// 伝搬経路を3D表示する
// dim = 0/1/2 : 観測点/観測線/観測面
void plot3dPath(int dim)
{
	// 新ページ
	ev3d_newPage();

	// 物体形状(灰色塗りつぶし)
	plot3d_geom(0, 1);

	// 受信点番号の範囲(irx0<=*<irx1)
	int irx0 = 0;
	int irx1 = 0;
	if      (dim == 0) {
		irx0 = 0;
		irx1 = NRx[0];
	}
	else if (dim == 1) {
		irx0 = NRx[0];
		irx1 = NRx[0] + NRx[1];
	}
	else if (dim == 2) {
		irx0 = NRx[0] + NRx[1];
		irx1 = NRx[0] + NRx[1] + NRx[2];
	}
	//printf("%d %d %d\n", dim, irx0, irx1);

	// 伝搬経路
	unsigned char rgb[3];
	for (int irx = irx0; irx < irx1; irx++) {
		//if (Rx[irx].npath) printf("%d %d %d\n", dim, irx, Rx[irx].npath);
		for (int ipath = 0; ipath < Rx[irx].npath; ipath++) {
			getpathcolor(Rx[irx].path[ipath].npos - 1, rgb);
			ev3d_setColor(rgb[0], rgb[1], rgb[2]);
			for (int ipos = 0; ipos < Rx[irx].path[ipath].npos - 1; ipos++) {
				double *p1 = Rx[irx].path[ipath].pos[ipos + 0];
				double *p2 = Rx[irx].path[ipath].pos[ipos + 1];
				ev3d_drawLine(p1[0], p1[1], p1[2], p2[0], p2[1], p2[2]);
			}
		}
	}

	// 色初期化
	ev3d_setColor(0, 0, 0);
}
