/*
plotutils.c
*/

#include <math.h>
#include "ort.h"
#include "ev.h"


// 線分数による伝搬経路の色分け
void getpathcolor(int nsegm, unsigned char rgb[3])
{
	if      (nsegm == 1) {
		rgb[0] = 255;
		rgb[1] =   0;
		rgb[2] =   0;
	}
	else if (nsegm == 2) {
		rgb[0] =   0;
		rgb[1] =   0;
		rgb[2] = 255;
	}
	else if (nsegm == 3) {
		rgb[0] =   0;
		rgb[1] = 255;
		rgb[2] =   0;
	}
	else if (nsegm == 4) {
		rgb[0] = 255;
		rgb[1] = 170;
		rgb[2] = 140;
	}
	else {
		rgb[0] =   0;
		rgb[1] = 200;
		rgb[2] = 200;
	}
}


// スケールを取得する
void getscale(double d, scale_t scale, double *smin, double *smax, int *sdiv)
{
	if (scale.user) {
		// ユーザー指定スケール
		*smin = scale.min;
		*smax = scale.max;
		*sdiv = scale.div;
	}
	else {
		// 自動スケール
		if (scale.db == 1) {
			// dB
			const double dbunit = 5;
			*smax = ceil(d / dbunit) * dbunit;
			*sdiv = 8;
			*smin = *smax - (*sdiv * dbunit);
		}
		else {
			// linear
			const int div[] = {1, 10, 10, 6, 8, 10, 6, 7, 8, 9, 10};
			const double exp = pow(10, floor(log10(MAX(d, EPS2))));
			const int dec = (int)((ceil)(d / exp));
			*smax = dec * exp;
			*smin = 0;
			*sdiv = div[dec];
		}
	}
}


// 観測面データの作成(2D/3Dで使用)
void calcRx2d(double *pdata[2], double *tdata[2])
{
	// 位相差あり/なし
	for (int comp = 0; comp < 2; comp++) {
		// 受信点の開始番号
		const int irx0 = NRx[0] + NRx[1];

		// 観測面の受信点に関するループ
		for (int irx = 0; irx < NRx[2]; irx++) {
			pdata[comp][irx] = 10 * log10(MAX(Rx[irx0 + irx].power[comp], EPS2));
			tdata[comp][irx] = Rx[irx0 + irx].delay[comp] * (1e9 / C);
		}
	}
}
