/*
post2d.c
ポスト処理 (2D)
*/

#include "ort.h"
#include "ort_prototype.h"
#include "ev.h"


void post2d(const char fn_ev2d[])
{
	// ウィンドウサイズ(2D)
	Width2d = 1.5;
	Height2d = 1.0;
	Fontsize2d = 0.025;

	// HTMLのときはピクセル値にする(Linux用)
	if (HTML) {
		Width2d    *= 500;
		Height2d   *= 500;
		Fontsize2d *= 500;
	}

	// 開始
	ev2d_init(Width2d, Height2d);

	// 観測点
	if (NRx0d) {
		if (Rx0d_profile) {
			// 遅延プロファイル
			plot2dRx0d();
		}
	}

	// 観測線
	if (NRx1d) {
		// 電力分布
		if (Rx1d_power) {
			plot2dRx1d(0);
		}
		// 遅延時間
		if (Rx1d_delay) {
			plot2dRx1d(1);
		}
	}

	// 観測面
	if (NRx2d) {
		plot2dRx2d();
	}

	// 出力
	ev2d_file(!HTML, !HTML ? fn_ev2d : "ev2d.htm");
	ev2d_output();
}
