/*
post3d.c
ポスト処理 (3D)
*/

#include "ort.h"
#include "ort_prototype.h"
#include "ev.h"


void post3d(const char fn_ev3d[])
{
	// 3D描画開始
	ev3d_init();

	// 観測点、伝搬経路
	if (Rx0d_path) {
		plot3dPath(0);
	}

	// 観測線、伝搬経路
	if (Rx1d_path) {
		plot3dPath(1);
	}

	// 観測線、遅延プロファイル
	if (Rx1d_profile) {
		plot3dRx1d();
	}

	// 観測面、伝搬経路
	if (Rx2d_path) {
		plot3dPath(2);
	}

	// 観測面、分布図
	if (Rx2d_power[0] || Rx2d_power[1] || Rx2d_delay[0] || Rx2d_delay[1]) {
		plot3dRx2d();
	}

	// 出力
	ev3d_file(!HTML, !HTML ? fn_ev3d : "ev3d.htm", 0);
	ev3d_output();
}
