/*
post_data.c
ポスト処理用のデータを読み込む
*/

#include "ort.h"
#include "ort_prototype.h"


int post_data(FILE *fp)
{
	int    version = 0;
	char   strline[MAXCHAR], strsave[MAXCHAR];
	char   strkey[BUFSIZ];
	char   *token[MAXTOKEN];
	const char sep[] = " \t";  // separator

	// 変数の初期化

	// Rx0d
	Rx0d_path                = 0;
	Rx0d_profile             = 0;
	Rx0d_profile_xscale.user = 0;
	Rx0d_profile_xscale.db   = 0;
	Rx0d_profile_yscale.user = 0;
	Rx0d_profile_yscale.db   = 1;

	// Rx1d
	Rx1d_path             = 0;
	Rx1d_profile          = 0;
	Rx1d_power            = 0;
	Rx1d_delay            = 0;
	Rx1d_power_scale.user = 0;
	Rx1d_power_scale.db   = 1;
	Rx1d_delay_scale.user = 0;
	Rx1d_delay_scale.db   = 0;

	// Rx2d
	Rx2d_path                     = 0;
	Rx2d_power[0] = Rx2d_power[1] = 0;
	Rx2d_delay[0] = Rx2d_delay[1] = 0;
	Rx2d_stat[0] = Rx2d_stat[1] = Rx2d_stat[2] = Rx2d_stat[3] = 0;
	Rx2d_decay[0] = Rx2d_decay[1] = 1;
	Rx2d_power_scale.user         = 0;
	Rx2d_power_scale.db           = 1;
	Rx2d_delay_scale.user         = 0;
	Rx2d_delay_scale.db           = 0;
	Rx2d_decay_scale.user         = 0;
	Rx2d_geometry                 = 1;

	// ファイルを読み込む

	int nline = 0;
	while (fgets(strline, sizeof(strline), fp) != NULL) {
		// 空行スキップ
		if (strlen(strline) <= 1) continue;

		// コメント行スキップ
		if (strline[0] == '#') continue;

		// 末尾の"\n"を除く
		if (strstr(strline, "\r\n") != NULL) {
			strline[strlen(strline) - 2] = '\0';
		}
		else if ((strstr(strline, "\r") != NULL) || (strstr(strline, "\n") != NULL)) {
			strline[strlen(strline) - 1] = '\0';
		}

		// "end"行 : 終了
		if (!strcmp(strline, "end")) break;

		// 文字列保存
		strcpy(strsave, strline);

		// トークン分解 (文字列"strline"は破壊される)
		const int ntoken = tokenize(strline, sep, token, MAXTOKEN);

		// キーワード
		strcpy(strkey, token[0]);

		// データ数(3以上)チェックと"="確認 (ヘッダーとタイトルは除く)
		if ((nline > 0) && strcmp(strkey, "title") && ((ntoken < 3) || strcmp(token[1], "="))) {
			warning(strkey, nline);
			continue;
		}

		if (nline == 0) {
			if (strcmp(strkey, "OpenRTM")) {
				fprintf(stderr, "*** not OpenRTM data\n");
				return 1;
			}
			if (ntoken > 1) {
				version = 100 * atoi(token[1]);  // major version
			}
			if (ntoken > 2) {
				version += atoi(token[2]);       // minor version
			}
			//printf("version=%d\n", version);
		}
		// Rx0d
		else if (!strcmp(strkey, "rx0d_path")) {
			if (ntoken > 2) {
				Rx0d_path = atoi(token[2]);
			}
			else {
				warning(strkey, nline);
			}
		}
		else if (!strcmp(strkey, "rx0d_profile")) {
			if (ntoken > 2) {
				Rx0d_profile = atoi(token[2]);
			}
			else {
				warning(strkey, nline);
			}
		}
		else if (!strcmp(strkey, "rx0d_profile_xscale")) {
			if (ntoken > 5) {
				Rx0d_profile_xscale.user = atoi(token[2]);
				Rx0d_profile_xscale.min  = atof(token[3]);
				Rx0d_profile_xscale.max  = atof(token[4]);
				Rx0d_profile_xscale.div  = atoi(token[5]);
			}
			else {
				warning(strkey, nline);
			}
		}
		else if (!strcmp(strkey, "rx0d_profile_yscale")) {
			if (ntoken > 5) {
				Rx0d_profile_yscale.user = atoi(token[2]);
				Rx0d_profile_yscale.min  = atof(token[3]);
				Rx0d_profile_yscale.max  = atof(token[4]);
				Rx0d_profile_yscale.div  = atoi(token[5]);
			}
			else {
				warning(strkey, nline);
			}
		}
		// Rx1d
		else if (!strcmp(strkey, "rx1d_path")) {
			if (ntoken > 2) {
				Rx1d_path = atoi(token[2]);
			}
			else {
				warning(strkey, nline);
			}
		}
		else if (!strcmp(strkey, "rx1d_profile")) {
			if (ntoken > 2) {
				Rx1d_profile = atoi(token[2]);
			}
			else {
				warning(strkey, nline);
			}
		}
		else if (!strcmp(strkey, "rx1d_power")) {
			if (ntoken > 2) {
				Rx1d_power = atoi(token[2]);
			}
			else {
				warning(strkey, nline);
			}
		}
		else if (!strcmp(strkey, "rx1d_delay")) {
			if (ntoken > 2) {
				Rx1d_delay = atoi(token[2]);
			}
			else {
				warning(strkey, nline);
			}
		}
		else if (!strcmp(strkey, "rx1d_power_scale")) {
			if (ntoken > 5) {
				Rx1d_power_scale.user = atoi(token[2]);
				Rx1d_power_scale.min  = atof(token[3]);
				Rx1d_power_scale.max  = atof(token[4]);
				Rx1d_power_scale.div  = atoi(token[5]);
			}
			else {
				warning(strkey, nline);
			}
		}
		else if (!strcmp(strkey, "rx1d_delay_scale")) {
			if (ntoken > 5) {
				Rx1d_delay_scale.user = atoi(token[2]);
				Rx1d_delay_scale.min  = atof(token[3]);
				Rx1d_delay_scale.max  = atof(token[4]);
				Rx1d_delay_scale.div  = atoi(token[5]);
			}
			else {
				warning(strkey, nline);
			}
		}
		// Rx2d
		else if (!strcmp(strkey, "rx2d_path")) {
			if (ntoken > 2) {
				Rx2d_path = atoi(token[2]);
			}
			else {
				warning(strkey, nline);
			}
		}
		else if (!strcmp(strkey, "rx2d_power")) {
			if (ntoken > 3) {
				Rx2d_power[0] = atoi(token[2]);
				Rx2d_power[1] = atoi(token[3]);
			}
			else {
				warning(strkey, nline);
			}
		}
		else if (!strcmp(strkey, "rx2d_delay")) {
			if (ntoken > 3) {
				Rx2d_delay[0] = atoi(token[2]);
				Rx2d_delay[1] = atoi(token[3]);
			}
			else {
				warning(strkey, nline);
			}
		}
		else if (!strcmp(strkey, "rx2d_stat")) {
			if (ntoken > 5) {
				Rx2d_stat[0] = atoi(token[2]);
				Rx2d_stat[1] = atoi(token[3]);
				Rx2d_stat[2] = atoi(token[4]);
				Rx2d_stat[3] = atoi(token[5]);
			}
			else {
				warning(strkey, nline);
			}
		}
		else if (!strcmp(strkey, "rx2d_decay")) {
			if (ntoken > 3) {
				Rx2d_decay[0] = atoi(token[2]);
				Rx2d_decay[1] = atoi(token[3]);
			}
			else {
				warning(strkey, nline);
			}
		}
		else if (!strcmp(strkey, "rx2d_power_scale")) {
			if (ntoken > 5) {
				Rx2d_power_scale.user = atoi(token[2]);
				Rx2d_power_scale.min  = atof(token[3]);
				Rx2d_power_scale.max  = atof(token[4]);
				Rx2d_power_scale.div  = atoi(token[5]);
			}
			else {
				warning(strkey, nline);
			}
		}
		else if (!strcmp(strkey, "rx2d_delay_scale")) {
			if (ntoken > 5) {
				Rx2d_delay_scale.user = atoi(token[2]);
				Rx2d_delay_scale.min  = atof(token[3]);
				Rx2d_delay_scale.max  = atof(token[4]);
				Rx2d_delay_scale.div  = atoi(token[5]);
			}
			else {
				warning(strkey, nline);
			}
		}
		else if (!strcmp(strkey, "rx2d_decay_scale")) {
			if (ntoken > 4) {
				Rx2d_decay_scale.user = atoi(token[2]);
				Rx2d_decay_scale.min  = atof(token[3]);
				Rx2d_decay_scale.max  = atof(token[4]);
			}
			else {
				warning(strkey, nline);
			}
		}
		else if (!strcmp(strkey, "rx2d_geometry")) {
			if (ntoken > 2) {
				Rx2d_geometry = atoi(token[2]);
			}
			else {
				warning(strkey, nline);
			}
		}

		// 行番号（warning用）
		nline++;
	}

	return 0;
}
