/*
readout.c
ort.outを読み込む
*/

#include "ort.h"


void readout(FILE *fp)
{
	fread(Title,      sizeof(char),       256,       fp);
	fread(&Frequency, sizeof(double),     1,         fp);
	fread(&NTriangle, sizeof(int),        1,         fp);
	fread(&NTx,       sizeof(int),        1,         fp);
	fread(&NRx0d,     sizeof(int),        1,         fp);
	fread(&NRx1d,     sizeof(int),        1,         fp);
	fread(&NRx2d,     sizeof(int),        1,         fp);
	fread(NRx,        sizeof(int),        4,         fp);
	fread(&Lbound,    sizeof(double),     1,         fp);

	// alloc
	Triangle = (triangle_t *)malloc(NTriangle * sizeof(triangle_t));
	Tx       =       (tx_t *)malloc(NTx       * sizeof(tx_t));
	Rx0d     =     (rx0d_t *)malloc(NRx0d     * sizeof(rx0d_t));
	Rx1d     =     (rx1d_t *)malloc(NRx1d     * sizeof(rx1d_t));
	Rx2d     =     (rx2d_t *)malloc(NRx2d     * sizeof(rx2d_t));

	fread(Triangle,   sizeof(triangle_t), NTriangle, fp);
	fread(Tx,         sizeof(tx_t),       NTx,       fp);
	fread(Rx0d,       sizeof(rx0d_t),     NRx0d,     fp);
	fread(Rx1d,       sizeof(rx1d_t),     NRx1d,     fp);
	fread(Rx2d,       sizeof(rx2d_t),     NRx2d,     fp);

	Rx = (rx_t *)malloc(NRx[3] * sizeof(rx_t));
	for (int irx = 0; irx < NRx[3]; irx++) {
		fread(Rx[irx].pos,      sizeof(double), 3, fp);
		fread(&Rx[irx].antenna, sizeof(int),    1, fp);
		fread(&Rx[irx].npath,   sizeof(int),    1, fp);
		fread(Rx[irx].power,    sizeof(double), 2, fp);
		fread(Rx[irx].delay,    sizeof(double), 2, fp);
		const int npath = Rx[irx].npath;
		if (npath > 0) {
			Rx[irx].path   =      (path_t *)malloc(npath * sizeof(path_t));
			Rx[irx].efield = (d_complex_t *)malloc(npath * sizeof(d_complex_t));
			for (int ipath = 0; ipath < npath; ipath++) {
				int npos;
				fread(&npos, sizeof(int), 1, fp);
				Rx[irx].path[ipath].npos = npos;
				Rx[irx].path[ipath].pos  = (double (*)[3])malloc(npos * 3 * sizeof(double));
				Rx[irx].path[ipath].itri =         (int *)malloc(npos * sizeof(int));
				fread(Rx[irx].path[ipath].pos,  sizeof(double),      npos * 3, fp);
				fread(Rx[irx].path[ipath].itri, sizeof(int),         npos,     fp);
				fread(&Rx[irx].efield[ipath],   sizeof(d_complex_t), 1,        fp);
			}
		}
	}
}
