/*
OpenRTM Version 1.0.1
計算部
*/

#define MAIN
#include "ort.h"
#undef MAIN

#include "ort_prototype.h"

static void args(int, char *[], int *, char []);

int main(int argc, char *argv[])
{
	const char fn_out[] = "ort.out";
	const char fn_log[] = "ort.log";
	const char fn_field[] = "field.log";
	const char fn_path[] = "path.log";
	const char errfmt[] = "*** file %s open error.\n";
	double t[] = {0, 0, 0, 0};
	FILE *fp_in, *fp_out, *fp_log;

	// 引数処理
	int prompt;
	char fn_in[BUFSIZ];
	args(argc, argv, &prompt, fn_in);
	//printf("%d %d %s\n", NThread, prompt, fn_in);

	// 計算時間測定
	t[0] = cputime();

	// スレッド数設定
#ifdef _OPENMP
	omp_set_num_threads(NThread);
#else
	NThread = 1;
#endif

	// 入力ファイルを開く
	if ((fp_in = fopen(fn_in, "r")) == NULL) {
		fprintf(stderr, errfmt, fn_in);
		exit(1);
	}

	// データ入力
	if (input_data(fp_in)) {
		// 入力データエラー処理
		if (prompt) {
			getchar();
		}
		if (!Plot3d[0] && !Plot3d[1]) {  // 指定された図形表示は行う
			exit(1);
		}
	}

	// 入力ファイルを閉じる
	fclose(fp_in);

	// logファイルを開く
	if ((fp_log = fopen(fn_log, "w")) == NULL) {
		fprintf(stderr, errfmt, fn_log);
		exit(1);
	}

	// 経過確認(1)
	monitor1(fp_log);

	// 各種準備
	setup();

	// 経過確認(2)
	monitor2(fp_log);

	// 入力データ3D表示
	if (Plot3d[0] || Plot3d[1]) {
		if (Plot3d[0]) {
			plot3d_data(0);  // 物体形状
		}
		if (Plot3d[1]) {
			plot3d_data(1);  // アンテナパターン
		}
		if (!Plot3d[2] || (MaxRef == 0)) {
			exit(0);  // 計算せずに終了
		}
	}

	// ローンチング法の前処理
	if (MaxRef > Icomp[1]) {
		// レイ計算
		setup_launching();
		// 経過確認(3)
		monitor3(fp_log);
		// レイ3D表示
		if (Plot3d[2]) {
			plot3d_data(2);
			exit(0);  // 計算せずに終了
		}
	}

	// 計算時間測定
	t[1] = cputime();

	// 主計算
	solve();

	// 計算時間測定
	t[2] = cputime();

	// 経過確認(4)
	monitor4(fp_log);

	// 数値出力
	outputlog(fn_field, fn_path);

	// 経過確認(5)
	monitor5(fp_log, fn_log, fn_out, fn_field, fn_path);

	// 出力ファイルを開く
	if ((fp_out = fopen(fn_out, "wb")) == NULL) {
		fprintf(stderr, errfmt, fn_out);
		exit(1);
	}

	// ファイル出力
	writeout(fp_out);

	// 出力ファイルを閉じる
	fclose(fp_out);

	// 計算時間測定
	t[3] = cputime();

	// 経過確認(6)
	monitor6(fp_log, t);

	// logファイルを閉じる
	fclose(fp_log);

	// 引数"-prompt"
	if (prompt) {
		getchar();
	}

	return 0;
}


// 引数処理
static void args(int argc, char *argv[], int *prompt, char fn_in[])
{
	const char usage[] = "Usage : ort [-n <thread>] [-html] <datafile>";

	if (argc < 2) {
		printf("%s\n", usage);
		exit(0);
	}

	// 既定値
	NThread = 1;
	HTML = 0;
	*prompt = 0;
	strcpy(fn_in, "");

	while (--argc) {
		++argv;
		if (!strcmp(*argv, "-n")) {
			if (--argc) {
				NThread = atoi(*++argv);
				NThread = MAX(1, NThread);
			}
			else {
				break;
			}
		}
		else if (!strcmp(*argv, "-html")) {
			HTML = 1;
		}
		else if (!strcmp(*argv, "-prompt")) {
			*prompt = 1;
		}
		else if (!strcmp(*argv, "--help")) {
			printf("%s\n", usage);
			exit(0);
		}
		else if (!strcmp(*argv, "--version")) {
			printf("%s Ver.%d.%d.%d\n", PROGRAM, VERSION_MAJOR, VERSION_MINOR, VERSION_BUILD);
			exit(0);
		}
		else {
			strcpy(fn_in, *argv);
		}
	}
}
