/*
los.c
*/

#include "ort.h"
#include "vector.h"
#include "ort_prototype.h"

static int cramer3(double [][3], const double [], double []);

/*
機能:
	点p1と点p2は見通し内(LOS)にあるか、途中で三角形に衝突しないか
入力:
	ends : 1のとき両端(点p1と点p2)も衝突判定に加える
	edge : 1のとき三角形の辺に衝突したときも衝突したとみなす
関数値:
	1 : 点p1と点p2は見通し内にある
*/
int los(const double p1[], const double p2[], int ends, int edge)
{
	double cross[3];
	int    ret = 1;

	for (int n = 0; n < NTriangle; n++) {
		if (intersect(p1, p2, &Triangle[n], cross, ends, edge)) {
			ret = 0;
			break;
		}
	}

	return ret;
}


/*
機能:
	点p1と点p2を結ぶ線分は三角形tと交差するか
入力:
	ends : 1のとき両端(点p1と点p2)も衝突判定に加える
	edge : 1のとき三角形の辺に衝突したときも衝突したとみなす
出力:
	cross : 交差する点の座標 [m]
*/
int intersect(const double p1[], const double p2[], triangle_t *t, double cross[], int ends, int edge)
{
	double r[3], fcol;

	// 簡易テスト
	if ((p1[0] == p2[0]) &&
	    (p1[1] == p2[1]) &&
	    (p1[2] == p2[2])) return 0;

	// 簡易テスト
	for (int k = 0; k < 3; k++) {
		if ((p1[k] < t->v[0][k]) && (p1[k] < t->v[1][k]) && (p1[k] < t->v[2][k]) &&
		    (p2[k] < t->v[0][k]) && (p2[k] < t->v[1][k]) && (p2[k] < t->v[2][k])) return 0;
		if ((p1[k] > t->v[0][k]) && (p1[k] > t->v[1][k]) && (p1[k] > t->v[2][k]) &&
		    (p2[k] > t->v[0][k]) && (p2[k] > t->v[1][k]) && (p2[k] > t->v[2][k])) return 0;
	}

	// 方向ベクトル
	vector_sub(p2, p1, r);

	// 衝突判定
	int ret = collide(p1, r, t, &fcol, edge);

	// 終点判定(始点はcollideで除かれている)
	const double eps = ends ? EPS : -EPS;
	ret = ret && (fcol < 1 + eps);

	// 交差する点の座標
	for (int k = 0; k < 3; k++) {
		cross[k] = p1[k] + (fcol * r[k]);
	}

	return ret;
}


/*
機能:
	点pから延びるベクトルrは三角形tに衝突するか
入力:
	edge : 1のとき三角形の辺に衝突したときも衝突したとみなす
出力:
	f : 衝突した点までの長さ / ベクトルrの長さ
*/
int collide(const double p[], const double r[], triangle_t *t, double *f, int edge)
{
	double a[3][3], b[3];
	double x[] = {0, 0, 0};

	// 行列aと右辺ベクトルb
	for (int k = 0; k < 3; k++) {
		a[k][0] = - r[k];
		a[k][1] = t->v[1][k] - t->v[0][k];
		a[k][2] = t->v[2][k] - t->v[0][k];
		b[k]    = p[k]       - t->v[0][k];
	}

	// Cramerの公式で解く
	const int ierr = cramer3(a, b, x);

	if (ierr) return 0;

	// 相対長さ
	*f = x[0];

	// 衝突したか
	const double eps = edge ? EPS : -EPS;
	return
		(x[0]        >   + EPS) &&  // 始点は除く
		(x[1]        >   - eps) &&
		(x[2]        >   - eps) &&
		(x[1] + x[2] < 1 + eps);
}


// Cramerの公式、大きさ=3
static int cramer3(double a[][3], const double b[], double x[])
{
	const double det
		= a[0][0] * (a[1][1] * a[2][2] - a[1][2] * a[2][1])
		+ a[0][1] * (a[1][2] * a[2][0] - a[1][0] * a[2][2])
		+ a[0][2] * (a[1][0] * a[2][1] - a[1][1] * a[2][0]);

	if (det == 0) return 1;

	const double rdet = 1 / det;

	x[0] = (+ b[0] * ((a[1][1] * a[2][2]) - (a[1][2] * a[2][1]))
	        - b[1] * ((a[0][1] * a[2][2]) - (a[0][2] * a[2][1]))
	        + b[2] * ((a[0][1] * a[1][2]) - (a[0][2] * a[1][1]))) * rdet;
	x[1] = (- b[0] * ((a[1][0] * a[2][2]) - (a[1][2] * a[2][0]))
	        + b[1] * ((a[0][0] * a[2][2]) - (a[0][2] * a[2][0]))
	        - b[2] * ((a[0][0] * a[1][2]) - (a[0][2] * a[1][0]))) * rdet;
	x[2] = (+ b[0] * ((a[1][0] * a[2][1]) - (a[1][1] * a[2][0]))
	        - b[1] * ((a[0][0] * a[2][1]) - (a[0][1] * a[2][0]))
	        + b[2] * ((a[0][0] * a[1][1]) - (a[0][1] * a[1][0]))) * rdet;

	return 0;
}
