/*
monitor.c
*/

#include "ort.h"


// 使用メモリー [MB]
static void memory_size(int *mem)
{
	// レイに関する配列 : Ray
	int sum_npos = 0;
	for (int n = 0; n < NRay; n++) {
		sum_npos += Ray[n].npos;
	}
	const int size0 = 1 * sizeof(int)      // itri
	                + 8 * sizeof(double);  // pos(3), length, cumlng, vector(3)
	const size_t mem0 = NRay * sizeof(ray_t) + sum_npos * size0;

	// 受信点に関する配列 : Rx
	const int maxpos = MAX(MaxRef, 1) + 2;
	const int size1 = 2 * sizeof(int)      // itri, rdt
	                + 3 * sizeof(double);  // pos(3)
	const size_t mem1 = NRx[3] * MaxPath * (sizeof(rx_t) + sizeof(path_t) + maxpos * size1);

	mem[0] = MAX((int)(mem0 / pow(2, 20)), 1);
	mem[1] = MAX((int)(mem1 / pow(2, 20)), 1);
}


// タイトル
static void monitor1_(FILE *fp)
{
	if (fp == NULL) return;

	char str[BUFSIZ];

	sprintf(str, "<<< %s Ver.%d.%d.%d >>>", PROGRAM, VERSION_MAJOR, VERSION_MINOR, VERSION_BUILD);
	fprintf(fp, "%s\n", str);

	fflush(fp);
}


// 計算条件
static void monitor2_(FILE *fp)
{
	if (fp == NULL) return;

	time_t now;
	time(&now);

	fprintf(fp, "%s", ctime(&now));
	fprintf(fp, "Title = %s\n", Title);
	fprintf(fp, "No. of threads          = %d\n", NThread);
	fprintf(fp, "No. of materials        = %d\n", NMaterial);
	fprintf(fp, "No. of antennas         = %d\n", NAntenna);
	fprintf(fp, "No. of triangles, edges = %d, %d\n", NTriangle, NEdge);
	fprintf(fp, "No. of Txs              = %d\n", NTx);
	fprintf(fp, "No. of Rx data          = %d + %d + %d = %d\n", NRx0d, NRx1d, NRx2d, NRx0d + NRx1d + NRx2d);
	fprintf(fp, "No. of Rxs (0d+1d+2d)   = %d + %d + %d = %d\n", NRx[0], NRx[1], NRx[2], NRx[3]);
	fprintf(fp, "Frequency [Hz]          = %.3e\n", Frequency);
	fprintf(fp, "Path : direct D T       = %d %d %d\n", Icomp[0], Icomp[2], Icomp[3]);
	fprintf(fp, "Max reflection times    = %d\n", MAX(Icomp[1], MaxRef));

	fflush(fp);
}


// 前処理結果
static void monitor3_(FILE *fp)
{
	if (fp == NULL) return;

	int mem[2];
	memory_size(mem);

	fprintf(fp, "No. of launched rays    = %d\n", NRay);
	fprintf(fp, "Memory size [MB]        = %d + %d = %d\n", mem[0], mem[1], mem[0] + mem[1]);

	fflush(fp);
}


// 計算結果の一部
static void monitor4_(FILE *fp)
{
	if (fp == NULL) return;

	// 伝搬経路数の和と平均
	int sum_path = 0;
	for (int irx = 0; irx < NRx[3]; irx++) {
		sum_path += Rx[irx].npath;
	}
	fprintf(fp, "Total, average paths    = %d, %.3f\n", sum_path, (double)sum_path / NRx[3]);

	// 最大伝搬経路数
	int max_path = 0;
	for (int irx = 0; irx < NRx[3]; irx++) {
		max_path = MAX(max_path, Rx[irx].npath);
	}
	fprintf(fp, "Max paths to a Rx-point = %d (%d)\n", max_path, MaxPath);

	// 平均受信電力
	double average[] = {0, 0};
	for (int n = 0; n < 2; n++) {
		double sum = 0;
		for (int irx = 0; irx < NRx[3]; irx++) {
			sum += Rx[irx].power[n];
		}
		sum /= NRx[3];
		average[n] = 10 * log10(MAX(sum, EPS2));
	}
	fprintf(fp, "Average of Rx power     = %.3f, %.3f [dBW]\n", average[0], average[1]);

	fflush(fp);
}


// 出力ファイル
static void monitor5_(FILE *fp, const char fn1[], const char fn2[], const char fn3[], const char fn4[])
{
	if (fp == NULL) return;

	char str[BUFSIZ];

	sprintf(str, "=== output files ===\n%s, %s", fn1, fn2);
	if (Log[0]) {
		strcat(str, ", "); strcat(str, fn3);
	}
	if (Log[1]) {
		strcat(str, ", "); strcat(str, fn4);
	}
	fprintf(fp, "%s\n", str);

	fflush(fp);
}


// 計算時間
static void monitor6_(FILE *fp, const double t[])
{
	if (fp == NULL) return;

	time_t now;
	time(&now);

	fprintf(fp, "%s\n", "=== normal end ===");
	fprintf(fp, "%s", ctime(&now));
	fprintf(fp, "=== cpu time [sec] ===\n");
	fprintf(fp, "part-1 :%10.3f\n", t[1] - t[0]);
	fprintf(fp, "part-2 :%10.3f\n", t[2] - t[1]);
	fprintf(fp, "part-3 :%10.3f\n", t[3] - t[2]);
	fprintf(fp, "------------------\n");
	fprintf(fp, "total  :%10.3f\n", t[3] - t[0]);

	fflush(fp);
}


void monitor1(FILE *fp)
{
	monitor1_(fp);
	monitor1_(stdout);
}


void monitor2(FILE *fp)
{
	monitor2_(fp);
	monitor2_(stdout);
}


void monitor3(FILE *fp)
{
	monitor3_(fp);
	monitor3_(stdout);
}


void monitor4(FILE *fp)
{
	monitor4_(fp);
	monitor4_(stdout);
}


void monitor5(FILE *fp, const char fn1[], const char fn2[], const char fn3[], const char fn4[])
{
	monitor5_(fp,     fn1, fn2, fn3, fn4);
	monitor5_(stdout, fn1, fn2, fn3, fn4);
}


void monitor6(FILE *fp, const double t[])
{
	monitor6_(fp,     t);
	monitor6_(stdout, t);
}
