/*
solve.c
計算の主要部
*/

#include "ort.h"
#include "ort_prototype.h"

// 伝搬経路を計算する
static void raypath(int irx, rx_t *rx)
{
	// 送信点に関するループ
	for (int itx = 0; itx < NTx; itx++) {
		// === [1] 直接法 ===
		if (Icomp[0]) {
			// 直接波 (direct)
			if (trace_s(itx, irx, &rx->npath, rx->path)) break;
		}
		if (Icomp[1]) {
			// 1回反射波 (reflection)
			if (trace_r(itx, irx, &rx->npath, rx->path)) break;
		}
		if (Icomp[2]) {
			// 1回回折波 (diffraction)
			if (trace_d(itx, irx, &rx->npath, rx->path)) break;
		}
		if (Icomp[3]) {
			// 1回透過波 (transmission)
			if (trace_t(itx, irx, &rx->npath, rx->path)) break;
		}

		// === [2] ローンチング法 ===
		if (MaxRef > Icomp[1]) {
			// 2回以上反射波 (reflection)
			if (launching(irx, &rx->npath, rx->path)) break;
		}
	}
}


// 伝搬経路の配列を作成する
static void alloc_rx(void)
{
	// 受信点に関するループ
	for (int irx = 0; irx < NRx[3]; irx++) {
		Rx[irx].npath = 0;
		Rx[irx].path = (path_t *)malloc(MaxPath * sizeof(path_t));
		Rx[irx].efield = (d_complex_t *)malloc(MaxPath * sizeof(d_complex_t));

		// 伝搬経路に関するループ
		const int maxpos = MAX(MaxRef, 1) + 2;
		for (int ipath = 0; ipath < MaxPath; ipath++) {
			Rx[irx].path[ipath].npos = 0;
			Rx[irx].path[ipath].pos  = (double (*)[3])calloc(maxpos * 3, sizeof(double));
			Rx[irx].path[ipath].itri =         (int *)calloc(maxpos, sizeof(int));
			Rx[irx].path[ipath].rdt  =         (int *)calloc(maxpos, sizeof(int));
		}
	}
}


// 受信電力その他を計算する
void solve(void)
{
	// 伝搬経路の配列を作成する
	alloc_rx();

	// 経過監視ステップ(1/10ごと)
	const int step = MAX((int)((NRx[3] / 10.0) + 0.5), 1);
	//printf("%d\n", step);

	// 受信点に関するループ（OpenMPによる並列計算）
	int irx;
#ifdef _OPENMP
#pragma omp parallel for
#endif
	for (irx = 0; irx < NRx[3]; irx++) {
		// 計算経過監視（どのスレッドが出力するかは不定であるが問題ない）
		if ((irx + 1) % step == 0) {
			printf(".");
			fflush(stdout);
		}

		// 伝搬経路を計算する
		raypath(irx, &Rx[irx]);
		//printf("%d %d\n", irx, Rx[irx].npath);

		// 伝搬経路の受信電界を計算する(遅延プロファイル用)
		for (int ipath = 0; ipath < Rx[irx].npath; ipath++) {
			Rx[irx].efield[ipath] = erxpath(&Rx[irx].path[ipath]);
			//printf("%d %d %e %e\n", irx, ipath, Rx[irx].efield[ipath].r, Rx[irx].efield[ipath].i);
		}

		// 受信電力と遅延時間を計算する
		rxstat(Rx[irx].npath, Rx[irx].path, Rx[irx].efield, Rx[irx].power, Rx[irx].delay);
		//printf("%d %e %e %e %e\n", irx, Rx[irx].power[0], Rx[irx].power[1], Rx[irx].delay[0], Rx[irx].delay[1]);
	}

	printf("\n");
}
