/*
writeout.c

ort.outを出力する
*/

#include "ort.h"


void writeout(FILE *fp)
{
	fwrite(Title,      sizeof(char),       256,       fp);
	fwrite(&Frequency, sizeof(double),     1,         fp);
	fwrite(&NTriangle, sizeof(int),        1,         fp);
	fwrite(&NTx,       sizeof(int),        1,         fp);
	fwrite(&NRx0d,     sizeof(int),        1,         fp);
	fwrite(&NRx1d,     sizeof(int),        1,         fp);
	fwrite(&NRx2d,     sizeof(int),        1,         fp);
	fwrite(NRx,        sizeof(int),        4,         fp);
	fwrite(&Lbound,    sizeof(double),     1,         fp);

	fwrite(Triangle,   sizeof(triangle_t), NTriangle, fp);
	fwrite(Tx,         sizeof(tx_t),       NTx,       fp);
	fwrite(Rx0d,       sizeof(rx0d_t),     NRx0d,     fp);
	fwrite(Rx1d,       sizeof(rx1d_t),     NRx1d,     fp);
	fwrite(Rx2d,       sizeof(rx2d_t),     NRx2d,     fp);

	for (int irx = 0; irx < NRx[3]; irx++) {
		fwrite(Rx[irx].pos,      sizeof(double), 3, fp);
		fwrite(&Rx[irx].antenna, sizeof(int),    1, fp);
		fwrite(&Rx[irx].npath,   sizeof(int),    1, fp);
		fwrite(Rx[irx].power,    sizeof(double), 2, fp);
		fwrite(Rx[irx].delay,    sizeof(double), 2, fp);
		const int npath = Rx[irx].npath;
		for (int ipath = 0; ipath < npath; ipath++) {
			const int npos = Rx[irx].path[ipath].npos;
			fwrite(&npos,                    sizeof(int),         1,        fp);
			fwrite(Rx[irx].path[ipath].pos,  sizeof(double),      npos * 3, fp);
			fwrite(Rx[irx].path[ipath].itri, sizeof(int),         npos,     fp);
			fwrite(&Rx[irx].efield[ipath],   sizeof(d_complex_t), 1,        fp);
		}
	}
}
