﻿using System.Drawing;
using System.Windows.Forms;

namespace OpenRTM
{
	public partial class frmEdit : Form
	{
        internal TextBox[] txtX, txtY, txtZ;

        public frmEdit(int target, string title, int xypos, int zpos)
		{
			InitializeComponent();

			this.Text = title;

			setDesign(target, xypos, zpos);
		}

		private void setDesign(int target, int xypos, int zpos)
		{
            // XY座標配列作成
            Label[] lblPos;
            lblPos = new Label[xypos];
			txtX = new TextBox[xypos];
			txtY = new TextBox[xypos];
			for (int i = 0; i < xypos; i++) {
				lblPos[i] = new Label();
				txtX[i] = new TextBox();
				txtY[i] = new TextBox();
			}

            // Z座標配列作成
			Label[] lblZ;
            lblZ = new Label[zpos];
            txtZ = new TextBox[zpos];
            for (int i = 0; i < zpos; i++) {
				lblZ[i] = new Label();
				txtZ[i] = new TextBox();
			}

			// XY座標
			int dh = Font.Height + 10;
			int sp = 5;
			int h = 10;
			int width = 80;
			for (int i = 0; i < xypos; i++) {
				lblPos[i].Top = h + 5;
				txtX[i].Top = txtY[i].Top = h;
				lblPos[i].Width = width;
				txtX[i].Width = txtY[i].Width = width;
				lblPos[i].Left = sp;
				txtX[i].Left = lblPos[i].Left + lblPos[i].Width + sp;
				txtY[i].Left = txtX[i].Left + txtX[i].Width + sp;
				lblPos[i].Text = (xypos > 1) ? ("点" + (i + 1).ToString() + ":") : string.Empty;
				txtX[i].TextAlign = txtY[i].TextAlign = HorizontalAlignment.Right;
				pnlPos.Controls.Add(lblPos[i]);
				pnlPos.Controls.Add(txtX[i]);
				pnlPos.Controls.Add(txtY[i]);
				h += dh;
			}

			// Z座標
			h = 10;
			for (int i = 0; i < zpos; i++) {
				lblZ[i].Top = h + 5;
				txtZ[i].Top = h;
				lblZ[i].Width = width;
				txtZ[i].Width = width;
				lblZ[i].Left = 3 * width + 5 * sp;
				txtZ[i].Left = lblZ[i].Left + lblZ[i].Width + sp;
				txtZ[i].TextAlign = HorizontalAlignment.Right;
				lblZ[i].Visible = false;
				pnlPos.Controls.Add(lblZ[i]);
				pnlPos.Controls.Add(txtZ[i]);
				h += dh;
			}

			// Z座標ラベル表示ON/OFF (zpos=0/2)
			if ((target == 0) && (zpos > 1)) {
				lblZ[0].Visible = lblZ[1].Visible = true;
				lblZ[0].Text = "上面:";
				lblZ[1].Text = "下面:";
			}

			// リスト名
            grpList.Text = ((target == 0) || (target == 1)) ? "物性値" : "アンテナ";
            
			// 表示ON/OFF
            grpCoordinate.Visible = (xypos > 0) || (zpos > 0);
			grpTx.Visible = (target == 2);
			lblDiv12.Visible = nudDiv12.Visible = (target == 4) || (target == 5);
			lblDiv14.Visible = nudDiv14.Visible = (target == 5);
		}
	}
}
