﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace OpenRTM
{
	public partial class frmOption : Form
	{
		public frmOption()
		{
			InitializeComponent();
		}

		// [初期化]
		private void btnInitialize_Click(object sender, EventArgs e)
		{
			string msg = "すべての設定を初期化します";
			if (MessageBox.Show(msg, btnInitialize.Text, MessageBoxButtons.OKCancel, MessageBoxIcon.Exclamation) == DialogResult.OK) {
				nudMaxMaterial.Value = nudMaxMaterial.Minimum;
				nudMaxAntenna.Value = nudMaxAntenna.Minimum;
				nudMaxPillar.Value = nudMaxPillar.Minimum;
				nudMaxPolygon.Value = nudMaxPolygon.Minimum;
				nudMaxTx.Value = nudMaxTx.Minimum;
				nudMaxRx0d.Value = nudMaxRx0d.Minimum;
				nudMaxRx1d.Value = nudMaxRx1d.Minimum;
				nudMaxRx2d.Value = nudMaxRx2d.Minimum;
				nudMaxMaterialAngle.Value = nudMaxMaterialAngle.Minimum;
				nudMaxVertex.Value = nudMaxVertex.Minimum;
				cboResolution.SelectedIndex = 2;
				nudNearPixel.Value = 10;
				nudPointSize.Value = 10;
				nudThread.Value = 8;
				chkClose.Checked = false;
			}
		}

		// [ヘルプ]
		private void btnHelp_Click(object sender, EventArgs e)
		{
			string msg
			= "●最大数\n"
			+ "データの数がここの値を超えるときは十分大きな数を入力してOpenRTMを再起動してください。\n\n"
			+ "●" + lblResolution.Text + "\n"
			+ "[物体形状]入力時の最小分解能です。グリッド表示の間隔になります。\n\n"
			+ "●" + lblNearPixel.Text + "\n"
			+ "[物体形状]編集時にマウスと線分の距離がこれ以下になると形状が選択されます。\n\n"
			+ "●" + lblPointLength.Text + "\n"
			+ "[物体形状]の送信点と観測点を表す正方形の大きさです。\n\n"
			+"●" + lblThread.Text + "\n"
			+ "計算のスレッド数です。論理コア数を推奨します。(4コア8スレッドのときは8)\n\n"
			+"(注意)\n"
			+ "ここの設定はアプリケーション単位で管理され、個々のデータには保存されません。";
			MessageBox.Show(msg, this.Text);
		}
	}
}
