﻿using System;
//using System.Collections.Generic;
using System.IO;
//using System.Linq;
using System.Text;
using System.Text.RegularExpressions;
//using System.Threading.Tasks;
using System.Windows.Forms;

namespace GML2ort
{
	internal class GSI
	{
		// GSI
		/*
		// 2次メッシュ
		//static int LATDIV = 750;
		//static int LONDIV = 1125;
		// 3次メッシュ
		static int LATDIV = 150;
		static int LONDIV = 225;
		*/
		static double GSIDEMSEA = -9999;       // 海の標高

		// 建物データを読み込む
		public static void ReadBld(string path, ref int NBldGSI, ref bldGSI_t[] BldGSI)
		{
			// 建物データ数を取得する
			int nbld = 0;
			using (var sr = new StreamReader(path, Encoding.UTF8))
			{
				try
				{
					string line;
					while ((line = sr.ReadLine()) != null)
					{
						if (line.Contains("<gml:posList>"))
						{
							nbld++;
						}
					}

				}
				catch { }
			}

			// 建物配列作成
			if (nbld > 0)
			{
				if (NBldGSI == 0)
				{
					BldGSI = new bldGSI_t[nbld];  // 最初のファイル
				}
				else
				{
					Array.Resize(ref BldGSI, NBldGSI + nbld);  // 2番目以降のファイル
				}
			}
			else
			{
				return;
			}

			const int maxvtx = 1000;                // 頂点数の最大値(通常200程度)
			double[] lat = new double[maxvtx];
			double[] lon = new double[maxvtx];
			Regex regex = new Regex(@"\s+");        // 1個以上の空白文字

			// 建物ファイルを読み込む
			using (var sr = new StreamReader(path, Encoding.UTF8))
			{
				try
				{
					bool dataflag = false;
					int nvtx = 0;
					string line;

					// 建物のデータは<gml:posList>行と</gml:posList>行で囲まれている
					// 各行はポリゴンの頂点の緯度と経度[度]から成る
					// XML parserを使用していない
					while ((line = sr.ReadLine()) != null)
					{
						if (line.Contains("<gml:posList>"))
						{
							// 建物データ開始
							dataflag = true;
							nvtx = 0;
						}
						else if (line.Contains("</gml:posList>"))
						{
							// 建物データ終了：建物配列に代入する
							dataflag = false;
							int n = NBldGSI;
							//BldGSI[n].lat = (double[])lat.Clone();
							//BldGSI[n].lon = (double[])lon.Clone();
							BldGSI[n].nvtx = nvtx;
							BldGSI[n].lat = new double[nvtx];
							BldGSI[n].lon = new double[nvtx];
							for (int i = 0; i < nvtx; i++)
							{
								BldGSI[n].lat[i] = lat[i];
								BldGSI[n].lon[i] = lon[i];
							}
							BldGSI[n].exclude = false;
							BldGSI[n].btall = false;
							NBldGSI++;
						}
						else if (dataflag)
						{
							// 頂点テータを取得
							string[] token = regex.Split(line);
							if (token.Length > 1)
							{
								Double.TryParse(token[0], out lat[nvtx]);
								Double.TryParse(token[1], out lon[nvtx]);
							}
							nvtx++;
						}
					}
				}
				catch (Exception ex)
				{
					MessageBox.Show(ex.Message + "\n" + path, "ReadBld");
				}
			}

			/*
			// 頂点数統計(debug)
			int max_nvtx = 0;
			for (int n = 0; n < NBld; n++)
			{
				max_nvtx = Math.Max(max_nvtx, Bld[n].nvtx);
			}
			int[] hist = new int[max_nvtx + 1];
			for (int n = 0; n < NBld; n++)
			{
				hist[Bld[n].nvtx]++;
			}
			using (var sw = new StreamWriter("nvtx.log"))
			{
				try
				{
					for (int i = 0; i <= max_nvtx; i++)
					{
						if (hist[i] > 0)
						{
							sw.WriteLine("{0} {1}", i, hist[i]);
						}
					}
				}
				catch { }
			}*/
		}

		// 標高データを読み込む
		public static void ReadDem(string path, ref int NDemFileGSI, ref demfile_t[] DemFileGSI, int latdiv, int londiv)
		{
			// 標高配列
			Array.Resize(ref DemFileGSI, NDemFileGSI + 1);
			DemFileGSI[NDemFileGSI] = new demfile_t(latdiv, londiv);

			// 標高作業配列、海面で初期化
			double[] h = new double[latdiv * londiv];
			for (int n = 0; n < latdiv * londiv; n++)
			{
				h[n] = GSIDEMSEA;
			}
			/*
			double[,] h = new double[LATDIV, LONDIV];
			for (int ilat = 0; ilat < LATDIV; ilat++)
			{
				for (int ilon = 0; ilon < LONDIV; ilon++)
				{
					h[ilat, ilon] = GSIDEMSEA;
				}
			}*/

			Regex regex = new Regex(@"\s+");   // 1個以上の空白文字
			char[] delim = { '<', '>' };       // 区切り文字

			using (var sr = new StreamReader(path, Encoding.UTF8))
			{
				try
				{
					string line;
					string[] token, token2;

					double latmin = 0, latmax = 0, lonmin = 0, lonmax = 0;
					bool dataflag = false;
					int num = 0;
					int num0 = 0; 

					while ((line = sr.ReadLine()) != null)
					{
						line = line.Trim();

						// 標高データ
						if (dataflag)
						{
							if (line.Contains(","))
							{
								// 標高は,で区切られた2番目の文字列
								token = line.Split(',');
								if (token.Length > 1)
								{
									/*if ((nlat >= LATDIV) || (lon0+nlon >= LONDIV))
									{
										Console.WriteLine(nlat + " " + nlon);
									}
									//Console.WriteLine(nlat + " " + nlon);
									if (nlon < LONDIV -1-lon0)
									{
										nlon++;
									}
									else
									{
										nlon = 0;
										nlat++;
									}*/
									Double.TryParse(token[1], out h[num]);
									num++;
								}
							}
						}

						// 標高データフラグ
						if (line.Contains("<gml:tupleList>"))
						{
							dataflag = true;
						}
						else if (line.Contains("</gml:tupleList>"))
						{
							dataflag = false;
						}

						// 緯度経度範囲
						if (line.Contains("<gml:lowerCorner>"))
						{
							// 南西
							token = line.Split(delim);
							if (token.Length > 2)
							{
								// 3番目の文字列が緯度経度
								token2 = regex.Split(token[2]);
								if (token2.Length > 1)
								{
									Double.TryParse(token2[0], out latmin);
									Double.TryParse(token2[1], out lonmin);
								}
							}
						}
						else if (line.Contains("<gml:upperCorner>"))
						{
							// 北東
							token = line.Split(delim);
							if (token.Length > 2)
							{
								// 3番目の文字列が緯度経度
								token2 = regex.Split(token[2]);
								if (token2.Length > 1)
								{
									Double.TryParse(token2[0], out latmax);
									Double.TryParse(token2[1], out lonmax);
								}
							}
						}

						// データ開始番号、途中から開始した後は1次元的に数える
						if (line.Contains("<gml:startPoint>"))
						{
							token = line.Split(delim);
							if (token.Length > 2)
							{
								// 3番目の文字列が"経度・緯度"の開始番号
								token2 = regex.Split(token[2]);
								if (token2.Length > 1)
								{
									Int32.TryParse(token2[0], out int lonnum0);
									Int32.TryParse(token2[1], out int latnum0);
									num0 = (latnum0 * londiv) + lonnum0;
								}
							}
						}

						/*
						// データ数
						if (line.Contains("<gml:low>"))
						{
							// 最初
							token = line.Split(delim);
							if (token.Length > 2)
							{
								// 3番目の文字列が緯度経度の最初
								token2 = regex.Split(token[2]);
								if (token2.Length > 1)
								{
									Double.TryParse(token2[0], out latnum0);
									Double.TryParse(token2[1], out lonnum0);
								}
							}
						}
						else if (line.Contains("<gml:high>"))
						{
							// 最後
							token = line.Split(delim);
							if (token.Length > 2)
							{
								// 3番目の文字列が緯度経度の最後
								token2 = regex.Split(token[2]);
								if (token2.Length > 1)
								{
									Double.TryParse(token2[0], out latnum1);
									Double.TryParse(token2[1], out lonnum1);
									latdiv = latnum1 - latnum0 + 1;
									latdiv = lonnum1 - lonnum0 + 1;
								}
							}
						}*/
					}

					// データ数チェック
					/*
					if (num != LATDIV * LONDIV)
					{
						string msg = "invalid number of data : " + num.ToString() + " <> " + (LATDIV * LONDIV).ToString() + "\n" + path;
						MessageBox.Show(msg);
					}*/
					if (num > latdiv * londiv)
					{
						string msg = "too many data : " + num.ToString() + " > " + (latdiv * londiv).ToString() + "\n" + path;
						MessageBox.Show(msg);
					}

					// 標高データ
					num = 0;
					double dlat = (latmax - latmin) / latdiv;
					double dlon = (lonmax - lonmin) / londiv;
					// N -> S
					for (int ilat = 0; ilat < latdiv; ilat++)
					{
						// W -> E
						for (int ilon = 0; ilon < londiv; ilon++)
						{
							//DemFileGSI[NDemFileGSI].hgt[LATDIV - 1 - ilat, ilon] = h[ilat, ilon];
							double hgt = (num >= num0) ? h[num - num0] : GSIDEMSEA;
							/*if (num >= num0)
							{
								hgt = h[num - num0];
							}*/
							num++;
							// 南北反転
							DemFileGSI[NDemFileGSI].hgt[latdiv - 1 - ilat, ilon] = hgt;
						}
					}

					// 緯度経度範囲
					DemFileGSI[NDemFileGSI].latmin = latmin;
					DemFileGSI[NDemFileGSI].latmax = latmax;
					DemFileGSI[NDemFileGSI].lonmin = lonmin;
					DemFileGSI[NDemFileGSI].lonmax = lonmax;

					// DEM番号
					string meshname = String.Empty;
					string filename = Path.GetFileName(path);
					token = filename.Split('-');
					if (path.ToLower().Contains("dem10") && (token.Length > 3))
					{
						meshname = token[2] + "-" + token[3];
					}
					else if (path.ToLower().Contains("dem5") && (token.Length > 4))
					{
						meshname = token[2] + "-" + token[3] + "-" + token[4];
					}
					DemFileGSI[NDemFileGSI].meshname = meshname;

					// DEMファイル数++
					NDemFileGSI++;
				}
				catch (Exception ex)
				{
					MessageBox.Show(ex.Message + "\n" + ex.StackTrace + "\n" + path, "ReadDem");
				}
			}
		}
	}
}
