﻿using System;
using System.Drawing;
using System.Windows.Forms;

namespace GML2ort
{
	public partial class Option : Form
	{
		public Option()
		{
			InitializeComponent();
		}

		private void btnInit_Click(object sender, EventArgs e)
		{
			string msg = "すべての設定を初期化します。";
			if (MessageBox.Show(msg, btnInit.Text, MessageBoxButtons.OKCancel, MessageBoxIcon.Exclamation) == DialogResult.OK) {
				chkOrigin.Checked = true;
				txtOrigin0.Text = "35";
				txtOrigin1.Text = "135";
				txtLearth.Text = "40000";
				btnBldColor.BackColor = Color.FromArgb(0, 0, 255);
				btnDemColor.BackColor = Color.FromArgb(180, 180, 120);
				//nudWidth3D.Value = 750;
				//nudHeight3D.Value = 500;
				//nudTheta3D.Value = 45;
				//nudPhi3D.Value = 270;
				txtGSIBldC0.Text = "3";
				txtGSIBldC1.Text = "0.05";
				txtBldFactor.Text = "5";
				rbnGSIDemMesh1.Checked = true;
				cboDemMesh.SelectedIndex = 0;
				chkDemRegex.Checked = false;
				chkRx2d.Checked = true;
				txtHRx2d.Text = "1.5";
				nudDRx2d.Value = 1;
			}
		}

		private void btnHelp_Click(object sender, EventArgs e)
		{
			string msg
			= "[" + grpOrigin.Text + "]\n"
			+ "・通常は[" + chkOrigin.Text + "]をONにしてください。OFFにすると緯度経度で指定することができます。\n\n"
			+ "[" + grpLearth.Text + "]\n"
			+ "・緯度・経度・標高をXYZ座標に変換するときに使用します。\n\n"
			+ "[" + grpColor.Text + "]\n"
			+ "・[...]をクリックすると建物と地面の色を変えることができます。\n\n"
			+ "[" + grpBld.Text + "]\n"
			+ "・" + grpGSIBld.Text + "：建物の高さ=基本高さ+比例定数*断面積 [m] になります。\n"
			+ "・" + lblBldFactor.Text + "拡大時にデータ番号を表示する閾値です。5程度が適当です。\n\n"
			+ "[" + grpDem.Text + "]\n"
			+ "・" + grpGSIDemMesh.Text + "：メッシュを選択してください。\n"
			+ "・" + lblDemMesh.Text + "地面の必要な解像度と処理時間を考慮して決めてください。これを小さくすると処理時間と出力ファイルサイズが大きくなります。\n"
			+ "・" + chkDemRegex.Text + "：" + grpDem.Text + "読み込み時に不具合があるときONにしてください。(PLATEAUのみ有効)\n\n"
			+ "[" + grpOpenRTM.Text + "]\n"
			+ "・" + chkRx2d.Text + "：ONにすると選択した地面の上に指定した地上高と分割数の観測面が出力されます。地面標高データがあるとき有効です。\n";
			MessageBox.Show(msg, btnHelp.Text, MessageBoxButtons.OK, MessageBoxIcon.Information);
		}

		private void chkOrigin_CheckedChanged(object sender, EventArgs e)
		{
			lblOrigin0.Enabled = lblOrigin1.Enabled = txtOrigin0.Enabled = txtOrigin1.Enabled = !chkOrigin.Checked;
		}

		private void btnBldColor_Click(object sender, EventArgs e)
		{
			if (colorDialog.ShowDialog() == DialogResult.OK)
			{
				btnBldColor.BackColor = colorDialog.Color;
			}
		}
		private void btnDemColor_Click(object sender, EventArgs e)
		{
			if (colorDialog.ShowDialog() == DialogResult.OK)
			{
				btnDemColor.BackColor = colorDialog.Color;
			}
		}

		private void chkRx2_CheckedChanged(object sender, EventArgs e)
		{
			lblHRx2d.Enabled = txtHRx2d.Enabled = lblDRx2d.Enabled = nudDRx2d.Enabled = chkRx2d.Checked;
		}

	}
}
