﻿using System;
//using System.Collections.Generic;
//using System.Linq;
//using System.Text;
//using System.Threading.Tasks;
using System.Text.RegularExpressions;
using System.IO;
//using System.Windows.Forms;
using System.Xml;
//using System.Runtime.CompilerServices;

namespace GML2ort
{
	internal class PLATEAU
	{
		// PLATEAU

		const int ARRAY_INC = 10000;
		const int MAX_VERTEX = 100;     // 頂点数最大数(通常30程度)

		// PLATEAUの建物と地面のデータを読み込む
		public static void ReadGML(string path, ref int NBldPLA, ref bldPLA_t[] BldPLA, ref int NDemTriPLA, ref double[][,] DemTriPLA, bool bregex)
		{

			//NDemTriPLA = 0;
			//NBldPLA = 0;

			XmlReaderSettings settings = new XmlReaderSettings();
			settings.IgnoreWhitespace = true;
			using (var fileStream = File.OpenText(path))
			using (XmlReader reader = XmlReader.Create(fileStream, settings))
			//using (XmlReader reader = XmlReader.Create(path, settings))
			{
				while (reader.Read())
				{
					switch (reader.NodeType)
					{
						case XmlNodeType.Element:
							if (reader.Name == "bldg:Building")
							{
								// 建物データを追加
								CreatePLATEAUBuilding(reader, ref NBldPLA, ref BldPLA);
							}
							else if (reader.Name == "gml:trianglePatches")
							{
								// 地面データを追加
								CreatePLATEAUDEM(reader, ref NDemTriPLA, ref DemTriPLA, bregex);
							}
							break;
						default:
							break;
					}
				}
			}

			/*
			// 頂点数統計(debug)
			int max_vrtx = 0;
			for (int n = 0; n < NBldPLA; n++)
			{
				max_vrtx = Math.Max(max_vrtx, BldPLA[n].nvtx);
			}
			int[] hist = new int[max_vrtx + 1];
			for (int n = 0; n < NBldPLA; n++)
			{
				hist[BldPLA[n].nvtx]++;
			}
			using (var sw = new StreamWriter("nvtx.log"))
			{
				try
				{
					for (int i = 0; i <= max_vrtx; i++) 
					{
						if (hist[i] > 0)
						{
							sw.WriteLine("{0} {1}", i, hist[i]);
						}
					}
				}
				catch { }
			}*/
		}

		// PLATEAUの建物データ追加
		private static void CreatePLATEAUBuilding(XmlReader reader, ref int NBldPLA, ref bldPLA_t[] BldPLA)
		{
			Regex regex = new Regex(@"\s+");    // 1個以上の空白文字

			XmlDocument doc = new XmlDocument();
			var r2 = reader.ReadSubtree();
			XmlNode cd = doc.ReadNode(r2);
			XmlNodeList member = cd.ChildNodes;

			foreach (XmlNode node in member)
			{
				// LOD1
				if (node.Name == "bldg:lod1Solid")
				{
					// 多角形の名前のリストを取得
					// <bldg:lod1Solid>の3個下が<gml:CompositeSurface> (ポリゴンの集合)
					XmlNodeList list = node.FirstChild.FirstChild.FirstChild.ChildNodes;

					for (int i = 0; i < list.Count; i++)
					{
						// <gml:CompositeSurface>の5個下が<gml:posList> (ポリゴンの頂点座標)
						string strpos = list[i].FirstChild.FirstChild.FirstChild.FirstChild.FirstChild.Value;
						strpos = strpos.Trim();
						// ファイルサイズが大きくないので常に正規表現を使う
						string[] token = regex.Split(strpos);

						// 現在のデータ数
						int n = NBldPLA;

						// 配列の大きさを拡張(時間がかかるので回数を減らす)
						if (n % ARRAY_INC == 0)
						{
							// サイズ拡張
							Array.Resize(ref BldPLA, n + ARRAY_INC);

							// 配列確保
							for (int narr = 0; narr < ARRAY_INC; narr++)
							{
								BldPLA[n + narr].lat = new double[MAX_VERTEX];
								BldPLA[n + narr].lon = new double[MAX_VERTEX];
								BldPLA[n + narr].hgt = new double[MAX_VERTEX];
							}
						}

						// データの代入
						BldPLA[n].nvtx = Math.Min(token.Length / 3, MAX_VERTEX);
						for (int iv = 0; iv < BldPLA[n].nvtx; iv++)
						{
							// 緯度、経度、標高
							BldPLA[n].lat[iv] = Double.Parse(token[(3 * iv) + 0]);
							BldPLA[n].lon[iv] = Double.Parse(token[(3 * iv) + 1]);
							BldPLA[n].hgt[iv] = Double.Parse(token[(3 * iv) + 2]);

							// 属性初期化
							BldPLA[n].exclude = false;
							//Console.WriteLine("{0} {1} {2} {3} {4}", n, iv, BldPLA[n].lat[iv], BldPLA[n].lon[iv], BldPLA[n].hgt[iv]);
						}

						// データ数++
						NBldPLA++;
					}
				}
			}
		}

		// PLATEAUの地面データ追加
		private static void CreatePLATEAUDEM(XmlReader reader, ref int NDemTriPLA, ref double[][,] DemTriPLA, bool bregex)
		{
			Regex regex = new Regex(@"\s+");    // 1個以上の空白文字
			//char[] sep = new char[] {' ', '\n'}; 

			XmlDocument doc = new XmlDocument();
			var r2 = reader.ReadSubtree();
			XmlNode cd = doc.ReadNode(r2);
			XmlNodeList member = cd.ChildNodes;

			foreach (XmlNode node in member)
			{
				if (node.Name == "gml:Triangle")
				{
					string strpos = node.InnerText;
					strpos = strpos.Trim();
					// Split関数を使用すると処理時間が約半分になる
					string[] token = bregex ? regex.Split(strpos) : strpos.Split(' ');

					// 現在のデータ数
					int n = NDemTriPLA;

					// 配列の大きさを拡張(時間がかかるので回数を減らす)
					if (n % ARRAY_INC == 0)
					{
						Array.Resize(ref DemTriPLA, n + ARRAY_INC);
						for (int narr = 0; narr < ARRAY_INC; narr++)
						{
							DemTriPLA[n + narr] = new double[4, 3];
						}
					}

					// 緯度・経度・標高の代入
					for (int m = 0; m < 4; m++)
					{
						for (int k = 0; k < 3; k++)
						{
							DemTriPLA[n][m, k] = Double.Parse(token[(3 * m) + k]);
						}
					}

					// データ数++
					NDemTriPLA++;
				}
			}
		}
	}
}
