﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace GML2ort
{
	internal class utils
	{
		/* test
		public static void test()
		{
			//double s = utils.area3(0, 1, 1, 0, 0, 1);
			//double s = utils.area4(2, 1, 1, 0, 0, 1, 2, 0);
			double[] x = { 2, 1, 1, 0 };
			double[] y = { 0, 1, 2, 0 };
			double s = utils.area(4, x, y);
			Console.WriteLine(s);
		}*/

		// XY面3角形の面積
		public static double area3(double x1, double x2, double x3, double y1, double y2, double y3)
		{
			return Math.Abs((x2 - x1) * (y3 - y1) - (x3 - x1) * (y2 - y1)) / 2;
		}

		// XY面4角形の面積
		// 凹型も正しい
		public static double area4(double x1, double x2, double x3, double x4, double y1, double y2, double y3, double y4)
		{
			double s123 = ((x2 - x1) * (y3 - y1) - (x3 - x1) * (y2 - y1)) / 2;
			double s134 = ((x3 - x1) * (y4 - y1) - (x4 - x1) * (y3 - y1)) / 2;
			return Math.Abs(s123 + s134);
		}

		// XY面多角形の面積
		// 凹型も正しい
		public static double area(int n, double[] x, double[] y)
		{
			double s = 0;
			for (int i = 0; i < n - 1; i++)
			{
				s += ((x[i] - x[0]) * (y[i + 1] - y[0]) - (x[i + 1] - x[0]) * (y[i] - y[0])) / 2;
			}
			return Math.Abs(s);
		}

		// 点(x, y)はポリゴン(xv, yv)の内部にあるか
		public static bool isInside(double x, double y, double[] xv, double[] yv, int nv)
		{
			// 座標の最小・最大値
			double xmin, ymin, xmax, ymax;
			xmin = xmax = xv[0];
			ymin = ymax = yv[0];
			for (int i = 0; i < nv; i++)
			{
				xmin = Math.Min(xmin, xv[i]);
				ymin = Math.Min(ymin, yv[i]);
				xmax = Math.Max(xmax, xv[i]);
				ymax = Math.Max(ymax, yv[i]);
			}
			// 十分遠方の点
			double xf = xmin + 100 * (xmax - xmin);
			double yf = ymin + 100 * (ymax - ymin);

			// 判定、十分遠方の点と結ぶ線分とポリゴンとの交点が奇数のとき内部にある
			int isum = 0;
			for (int i = 0; i < nv; i++)
			{
				int i1 = (i < nv - 1) ? (i + 1) : 0;
				double x1 = xv[i];
				double x2 = xv[i1];
				double y1 = yv[i];
				double y2 = yv[i1];
				double det = (x1 - x) * (y2 - y) - (x2 - x) * (y1 - y);
				if (det != 0)
				{
					double a1 = ((xf - x) * (y2 - y) - (yf - y) * (x2 - x)) / det;
					double a2 = ((yf - y) * (x1 - x) - (xf - x) * (y1 - y)) / det;
					if ((a1 > 0) && (a2 > 0))
					{
						isum++;
					}
				}
			}

			return (isum % 2 == 1);
		}

		// 多角形の重心に一番近い頂点番号を探す (2D)
		public static int innermost_vertex(int nv, double[] x, double[] y)
		{
			if (nv < 4) return 0;

			// 重心座標
			double sumx = 0;
			double sumy = 0;
			for (int i = 0; i < nv; i++)
			{
				sumx += x[i];
				sumy += y[i];
			}
			double x0 = sumx / nv;
			double y0 = sumy / nv;

			// 探索
			int iret = 0;
			double d2min = 1e16;
			for (int i = 0; i < nv; i++)
			{
				double d2 = (x[i] - x0) * (x[i] - x0) + (y[i] - y0) * (y[i] - y0);
				if (d2 < d2min)
				{
					iret = i;
					d2min = d2;
				}
			}

			return iret;
		}

	}
}
