/*
mur.c
Mur-ABC
*/

#include <stdio.h>
#include <math.h>

extern float C;

// Ez更新
void murEz(int Nx, int Ny, float Dt, float *Xn, float *Yn, float **Ez, float **Ezmurx, float **Ezmury, float Eps0)
{
	// 係数
	const float v = C / (float)sqrt(Eps0);
	const float vdt = v * Dt;
	float dx[2], dy[2], fx[2], fy[2];
	dx[0] = Xn[ 1] - Xn[     0];
	dx[1] = Xn[Nx] - Xn[Nx - 1];
	dy[0] = Yn[ 1] - Yn[     0];
	dy[1] = Yn[Ny] - Yn[Ny - 1];
	for (int m = 0; m < 2; m++) {
		fx[m] = (vdt - dx[m]) / (vdt + dx[m]);
		fy[m] = (vdt - dy[m]) / (vdt + dy[m]);
	}

	// X境界
	for (int j = 0; j < Ny + 1; j++) {
		Ez[ 0][j] = Ezmurx[0][j] + fx[0] * (Ez[     1][j] - Ez[ 0][j]);
		Ez[Nx][j] = Ezmurx[1][j] + fx[1] * (Ez[Nx - 1][j] - Ez[Nx][j]);
		Ezmurx[0][j] = Ez[     1][j];
		Ezmurx[1][j] = Ez[Nx - 1][j];
	}

	// Y境界
	for (int i = 0; i < Nx + 1; i++) {
		Ez[i][ 0] = Ezmury[0][i] + fy[0] * (Ez[i][     1] - Ez[i][ 0]);
		Ez[i][Ny] = Ezmury[1][i] + fy[1] * (Ez[i][Ny - 1] - Ez[i][Ny]);
		Ezmury[0][i] = Ez[i][     1];
		Ezmury[1][i] = Ez[i][Ny - 1];
	}
}
