/*
pml.c
PML-ABC
*/

#include <math.h>

extern float C;

// PML-Ez係数
void setupPmlEz(int ABC, int Nx, int Ny, float Dt, float Eps0,
	float *Xn, float *Yn, float *dXn, float *dYn,
	float *fpml, float *fezx, float *fezy, float *dezx, float *dezy)
{
	const float vdt = C * Dt / (float)sqrt(Eps0);
	const float eps = Eps0;

	for (int i = -ABC; i < Nx + ABC + 1; i++) {
		float fc, dx;
		if      (i <      1) {
			fc = fpml[- 2 * (i     )] / (Xn[ 1] - Xn[     0]);
			dx = dXn[ 0];
		}
		else if (i > Nx - 1) {
			fc = fpml[+ 2 * (i - Nx)] / (Xn[Nx] - Xn[Nx - 1]);
			dx = dXn[Nx];
		}
		else {
			fc = 0;
			dx = dXn[ i];
		}
		fezx[i + ABC] = 1 / (1 + vdt * fc);
		dezx[i + ABC] = dx / eps;
	}
	for (int j = -ABC; j < Ny + ABC + 1; j++) {
		float fc, dy;
		if      (j <      1) {
			fc = fpml[- 2 * (j     )] / (Yn[ 1] - Yn[     0]);
			dy = dYn[ 0];
		}
		else if (j > Ny - 1) {
			fc = fpml[+ 2 * (j - Ny)] / (Yn[Ny] - Yn[Ny - 1]);
			dy = dYn[Ny];
		}
		else {
			fc = 0;
			dy = dYn[j];
		}
		fezy[j + ABC] = 1 / (1 + vdt * fc);
		dezy[j + ABC] = dy / eps;
	}
}


// PML-Hx係数
void setupPmlHx(int ABC, int Ny, float Dt, float Eps0,
	float *Yn, float *dYc,
	float *fpml, float *fhx, float *dhx)
{
	const float vdt = C * Dt / (float)sqrt(Eps0);
	const float amu = 1;  // 磁性体なし

	for (int j = -ABC; j < Ny + ABC + 0; j++) {
		float fc, dy;
		if      (j <      0) {
			fc = fpml[- 2 * (j     ) - 1] / (Yn[1 ] - Yn[0     ]);
			dy = dYc[     0];
		}
		else if (j > Ny - 1) {
			fc = fpml[+ 2 * (j - Ny) + 1] / (Yn[Ny] - Yn[Ny - 1]);
			dy = dYc[Ny - 1];
		}
		else {
			fc = 0;
			dy = dYc[j];
		}
		fhx[j + ABC] = 1 / (1 + vdt * fc);
		dhx[j + ABC] = dy / amu;
	}
}


// PML-Hy係数
void setupPmlHy(int ABC, int Nx, float Dt, float Eps0,
	float *Xn, float *dXc,
	float *fpml, float *fhy, float *dhy)
{
	const float vdt = C * Dt / (float)sqrt(Eps0);
	const float amu = 1;  // 磁性体なし

	for (int i = -ABC; i < Nx + ABC + 0; i++) {
		float fc, dx;
		if      (i <      0) {
			fc = fpml[- 2 * (i     ) - 1] / (Xn[1 ] - Xn[0     ]);
			dx = dXc[     0];
		}
		else if (i > Nx - 1) {
			fc = fpml[+ 2 * (i - Nx) + 1] / (Xn[Nx] - Xn[Nx - 1]);
			dx = dXc[Nx - 1];
		}
		else {
			fc = 0;
			dx = dXc[i];
		}
		fhy[i + ABC] = 1 / (1 + vdt * fc);
		dhy[i + ABC] = dx / amu;
	}
}


// Ez
void pmlEz(int ABC, int Nx, int Ny,
	float **Ez, float **Hx, float **Hy, float **Ezx, float **Ezy,
	float *fezx, float *fezy, float *dezx, float *dezy)
{
	for (int i = -ABC + 1; i < Nx + ABC + 0; i++) {
	for (int j = -ABC + 1; j < Ny + ABC + 0; j++) {
		if ((i < 0) || (Nx - 0 < i) ||
		    (j < 0) || (Ny - 0 < j)) {
			const float dhy = Hy[i     + ABC][j     + ABC]
			                - Hy[i - 1 + ABC][j     + ABC];
			Ezx[i + ABC][j + ABC] = (
			Ezx[i + ABC][j + ABC] + dezx[i + ABC] * dhy) * fezx[i + ABC];

			const float dhx = Hx[i     + ABC][j     + ABC]
			                - Hx[i     + ABC][j - 1 + ABC];
			Ezy[i + ABC][j + ABC] = (
			Ezy[i + ABC][j + ABC] - dezy[j + ABC] * dhx) * fezy[j + ABC];

			Ez[i + ABC][j + ABC] = Ezx[i + ABC][j + ABC]
			                     + Ezy[i + ABC][j + ABC];
		}
	}
	}
}


// PML-Hx
void pmlHx(int ABC, int Nx, int Ny,
	float **Ez, float **Hx,
	float *fhx, float *dhx)
{
	for (int i = -ABC + 1; i < Nx + ABC + 0; i++) {
	for (int j = -ABC + 0; j < Ny + ABC + 0; j++) {
		if ((i < 0) || (Nx - 0 < i) ||
		    (j < 0) || (Ny - 1 < j)) {
			const float dez = Ez[i    + ABC][j + 1 + ABC]
			                - Ez[i    + ABC][j     + ABC];
			Hx[i + ABC][j + ABC] = (
			Hx[i + ABC][j + ABC] - dhx[j + ABC] * dez) * fhx[j + ABC];
		}
	}
	}
}


// PML-Hy
void pmlHy(int ABC, int Nx, int Ny,
	float **Ez, float **Hy,
	float *fhy, float *dhy)
{
	for (int i = -ABC + 0; i < Nx + ABC + 0; i++) {
	for (int j = -ABC + 1; j < Ny + ABC + 0; j++) {
		if ((i < 0) || (Nx - 1 < i) ||
		    (j < 0) || (Ny - 0 < j)) {
			const float dez = Ez[i + 1 + ABC][j    + ABC]
			                - Ez[i     + ABC][j    + ABC];
			Hy[i + ABC][j + ABC] = (
			Hy[i + ABC][j + ABC] + dhy[i + ABC] * dez) * fhy[i + ABC];
		}
	}
	}
}
