/*
txrx.c
送受信点座標
*/

#include <stdio.h>
#include <assert.h>

void txrx(int Nant, int Nx, int Ny, int Nout, int Lant, const int Pant[],
	int NTx, int *iTx, int *jTx,
	int NRx, int *iRx, int *jRx)
{
	assert(NTx == NRx);
	assert((Nant == 1) || (Nant == 2));

	// 送信点
	int ntx = 0;
	if      (Nant == 1) {
		// -X
		for (int ja = 0; ja < Pant[2]; ja++) {
			iTx[ntx] = Nout - Lant;  // 左
			jTx[ntx] = Nout + Pant[0] + (ja * Pant[1]);  // 下→上
			ntx++;
		}
	}
	else if (Nant == 2) {
		// -X
		for (int ja = 0; ja < Pant[2]; ja++) {
			iTx[ntx] = Nout - Lant;   // 左
			//jTx[ntx] = Nout + Pant[0] + (ja * Pant[1]);  // 下→上
			jTx[ntx] = Nout + Pant[0] + ((Pant[2] - 1 - ja) * Pant[1]);  // 上→下
			ntx++;
		}
		// -Y
		for (int ia = 0; ia < Pant[2]; ia++) {
			iTx[ntx] = Nout + Pant[0] + (ia * Pant[1]);  // 左→右
			//iTx[ntx] = Nout + Pant[0] + ((Pant[2] - 1 - ia) * Pant[1]);  // 右→左
			jTx[ntx] = Nout - Lant;  // 下
			ntx++;
		}
	}
	assert(ntx == NTx);

	// 受信点（XY対称）
	for (int n = 0; n < NRx; n++) {
		iRx[n] = Nx - iTx[n];
		jRx[n] = Ny - jTx[n];
	}

	// check
	for (int n = 0; n < NTx; n++) {
		//printf("Tx: %d %d %d\n", n, iTx[n], jTx[n]);
		assert((iTx[n] > 0) && (iTx[n] < Nx) && (jTx[n] > 0) && (jTx[n] < Ny));
	}
	for (int n = 0; n < NRx; n++) {
		//printf("Rx: %d %d %d\n", n, iRx[n], jRx[n]);
		assert((iRx[n] > 0) && (iRx[n] < Nx) && (jRx[n] > 0) && (jRx[n] < Ny));
	}
}
