/*
mur.c
Mur-ABC
*/

#include <stdio.h>
#include <math.h>

extern float C;

// Ex更新
void murEx(int Nx, int Ny, int Nz, float Dt, float *Yn, float *Zn,
	float ***Ex, float ***Exmury, float ***Exmurz, float Eps0)
{
	// 係数
	const float v = C / (float)sqrt(Eps0);
	const float vdt = v * Dt;
	float dy[2], dz[2], fy[2], fz[2];
	dy[0] = Yn[ 1] - Yn[     0];
	dy[1] = Yn[Ny] - Yn[Ny - 1];
	dz[0] = Zn[ 1] - Zn[     0];
	dz[1] = Zn[Nz] - Zn[Nz - 1];
	for (int m = 0; m < 2; m++) {
		fy[m] = (vdt - dy[m]) / (vdt + dy[m]);
		fz[m] = (vdt - dz[m]) / (vdt + dz[m]);
	}

	// Y境界
	for (int k = 0; k < Nz + 1; k++) {
	for (int i = 0; i < Nx + 0; i++) {
		Ex[i][ 0][k] = Exmury[0][k][i] + fy[0] * (Ex[i][     1][k] - Ex[i][ 0][k]);
		Ex[i][Ny][k] = Exmury[1][k][i] + fy[1] * (Ex[i][Ny - 1][k] - Ex[i][Ny][k]);
		Exmury[0][k][i] = Ex[i][     1][k];
		Exmury[1][k][i] = Ex[i][Ny - 1][k];
	}
	}

	// Z境界
	for (int j = 0; j < Ny + 1; j++) {
	for (int i = 0; i < Nx + 0; i++) {
		Ex[i][j][ 0] = Exmurz[0][j][i] + fz[0] * (Ex[i][j][     1] - Ex[i][j][ 0]);
		Ex[i][j][Nz] = Exmurz[1][j][i] + fz[1] * (Ex[i][j][Nz - 1] - Ex[i][j][Nz]);
		Exmurz[0][j][i] = Ex[i][j][     1];
		Exmurz[1][j][i] = Ex[i][j][Nz - 1];
	}
	}
}


// Ey更新
void murEy(int Nx, int Ny, int Nz, float Dt, float *Zn, float *Xn,
	float ***Ey, float ***Eymurz, float ***Eymurx, float Eps0)
{
	// 係数
	const float v = C / (float)sqrt(Eps0);
	const float vdt = v * Dt;
	float dz[2], dx[2], fz[2], fx[2];
	dz[0] = Zn[ 1] - Zn[     0];
	dz[1] = Zn[Nz] - Zn[Nz - 1];
	dx[0] = Xn[ 1] - Xn[     0];
	dx[1] = Xn[Nx] - Xn[Nx - 1];
	for (int m = 0; m < 2; m++) {
		fz[m] = (vdt - dz[m]) / (vdt + dz[m]);
		fx[m] = (vdt - dx[m]) / (vdt + dx[m]);
	}

	// Z境界
	for (int i = 0; i < Nx + 1; i++) {
	for (int j = 0; j < Ny + 0; j++) {
		Ey[i][j][ 0] = Eymurz[0][i][j] + fz[0] * (Ey[i][j][     1] - Ey[i][j][ 0]);
		Ey[i][j][Nz] = Eymurz[1][i][j] + fz[1] * (Ey[i][j][Nz - 1] - Ey[i][j][Nz]);
		Eymurz[0][i][j] = Ey[i][j][     1];
		Eymurz[1][i][j] = Ey[i][j][Nz - 1];
	}
	}

	// X境界
	for (int k = 0; k < Nz + 1; k++) {
	for (int j = 0; j < Ny + 0; j++) {
		Ey[ 0][j][k] = Eymurx[0][k][j] + fx[0] * (Ey[     1][j][k] - Ey[ 0][j][k]);
		Ey[Nx][j][k] = Eymurx[1][k][j] + fx[1] * (Ey[Nx - 1][j][k] - Ey[Nx][j][k]);
		Eymurx[0][k][j] = Ey[     1][j][k];
		Eymurx[1][k][j] = Ey[Nx - 1][j][k];
	}
	}
}


// Ez更新
void murEz(int Nx, int Ny, int Nz, float Dt, float *Xn, float *Yn,
	float ***Ez, float ***Ezmurx, float ***Ezmury, float Eps0)
{
	// 係数
	const float v = C / (float)sqrt(Eps0);
	const float vdt = v * Dt;
	float dx[2], dy[2], fx[2], fy[2];
	dx[0] = Xn[ 1] - Xn[     0];
	dx[1] = Xn[Nx] - Xn[Nx - 1];
	dy[0] = Yn[ 1] - Yn[     0];
	dy[1] = Yn[Ny] - Yn[Ny - 1];
	for (int m = 0; m < 2; m++) {
		fx[m] = (vdt - dx[m]) / (vdt + dx[m]);
		fy[m] = (vdt - dy[m]) / (vdt + dy[m]);
	}

	// X境界
	for (int j = 0; j < Ny + 1; j++) {
	for (int k = 0; k < Nz + 0; k++) {
		Ez[ 0][j][k] = Ezmurx[0][j][k] + fx[0] * (Ez[     1][j][k] - Ez[ 0][j][k]);
		Ez[Nx][j][k] = Ezmurx[1][j][k] + fx[1] * (Ez[Nx - 1][j][k] - Ez[Nx][j][k]);
		Ezmurx[0][j][k] = Ez[     1][j][k];
		Ezmurx[1][j][k] = Ez[Nx - 1][j][k];
	}
	}

	// Y境界
	for (int i = 0; i < Nx + 1; i++) {
	for (int k = 0; k < Nz + 0; k++) {
		Ez[i][ 0][k] = Ezmury[0][i][k] + fy[0] * (Ez[i][     1][k] - Ez[i][ 0][k]);
		Ez[i][Ny][k] = Ezmury[1][i][k] + fy[1] * (Ez[i][Ny - 1][k] - Ez[i][Ny][k]);
		Ezmury[0][i][k] = Ez[i][     1][k];
		Ezmury[1][i][k] = Ez[i][Ny - 1][k];
	}
	}
}
