/*
plot3d.c
3D}`o, debugp
*/

#include <stdio.h>
#include <string.h>
#include <assert.h>

#include "../fdtd2d/ev.h"

// vZ̈, Uď`, M_
void plot3d_g(int idata0, int idata1, int Nx, int Ny, int Nz, int Nout,
	int NTx, int *iTx, int *jTx, int *kTx, int *mTx,
	int NRx, int *iRx, int *jRx, int *kRx, int *mRx, const char fn[])
{
	assert((Nx > 0) && (Ny > 0) && (Nz > 0));
	assert ((idata0 >= 0) && (idata1 > idata0));
	char str[BUFSIZ];

	// Jn
	ev3d_init();

	// 1f[^=1y[W
	for (int idata = idata0; idata < idata1; idata++) {
		// y[W
		ev3d_newPage();

		// vZ̈
		ev3d_setColor(100, 100, 100);
		ev3d_drawBox(0, 0, 0, Nx, Ny, Nz);
		ev3d_drawBox(Nout, Nout, Nout, Nx - Nout, Ny - Nout, Nz - Nout);

		// M_(Z)
		ev3d_setColor(255, 0, 0);
		for (int itx = 0; itx < NTx; itx++) {
			const int i = iTx[itx];
			const int j = jTx[itx];
			const int k = kTx[itx];
			const int m = mTx[itx];
			if      (m == 0) {
				ev3d_drawLine(i, j, k, i + 1, j, k);
			}
			else if (m == 1) {
				ev3d_drawLine(i, j, k, i, j + 1, k);
			}
			else if (m == 2) {
				ev3d_drawLine(i, j, k, i, j, k + 1);
			}
		}

		// M_(Z)
		ev3d_setColor(0, 255, 0);
		for (int irx = 0; irx < NRx; irx++) {
			const int i = iRx[irx];
			const int j = jRx[irx];
			const int k = kRx[irx];
			const int m = mRx[irx];
			if      (m == 0) {
				ev3d_drawLine(i, j, k, i + 1, j, k);
			}
			else if (m == 1) {
				ev3d_drawLine(i, j, k, i, j + 1, k);
			}
			else if (m == 2) {
				ev3d_drawLine(i, j, k, i, j, k + 1);
			}
		}

		// ^Cg
		const int mx = Nx - (2 * Nout);
		const int my = Ny - (2 * Nout);
		const int mz = Nz - (2 * Nout);
		sprintf(str, "data=%d Nx=%d Ny=%d Nz=%d Mx=%d My=%d Mz=%d Tx=%d Rx=%d",
			idata + 1, Nx, Ny, Nz, mx, my, mz, NTx, NRx);
		ev3d_drawTitle(str);
	}

	// o
	ev3d_file(1, fn, 0);
	ev3d_output();
}
