/*
pml.c
PML-ABC
*/

#include <math.h>

extern float C;

// PML-Ex係数
void setupPmlEx(int ABC, int Ny, int Nz, float Dt, float Eps0,
	float *Yn, float *Zn, float *dYn, float *dZn,
	float *fpml, float *fexy, float *fexz, float *dexy, float *dexz)
{
	const float vdt = C * Dt / (float)sqrt(Eps0);
	const float epsr = Eps0;

	for (int j = -ABC; j < Ny + ABC + 1; j++) {
		float fc, dy;
		if      (j <      1) {
			fc = fpml[- 2 * (j     )    ] / (Yn[1 ] - Yn[0     ]);
			dy = dYn[ 0];
		}
		else if (j > Ny - 1) {
			fc = fpml[+ 2 * (j - Ny)    ] / (Yn[Ny] - Yn[Ny - 1]);
			dy = dYn[Ny];
		}
		else {
			fc = 0;
			dy = dYn[j];
		}
		fexy[j + ABC] = 1 / (1 + vdt * fc);
		dexy[j + ABC] = dy / epsr;
	}

	for (int k = -ABC; k < Nz + ABC + 1; k++) {
		float fc, dz;
		if      (k <      1) {
			fc = fpml[- 2 * (k     )    ] / (Zn[1 ] - Zn[0     ]);
			dz = dZn[ 0];
		}
		else if (k > Nz - 1) {
			fc = fpml[+ 2 * (k - Nz)    ] / (Zn[Nz] - Zn[Nz - 1]);
			dz = dZn[Nz];
		}
		else {
			fc = 0;
			dz = dZn[k];
		}
		fexz[k + ABC] = 1 / (1 + vdt * fc);
		dexz[k + ABC] = dz / epsr;
	}
}


// PML-Ey係数
void setupPmlEy(int ABC, int Nz, int Nx, float Dt, float Eps0,
	float *Zn, float *Xn, float *dZn, float *dXn,
	float *fpml, float *feyz, float *feyx, float *deyz, float *deyx)
{
	const float vdt = C * Dt / (float)sqrt(Eps0);
	const float epsr = Eps0;

	for (int k = -ABC; k < Nz + ABC + 1; k++) {
		float fc, dz;
		if      (k <      1) {
			fc = fpml[- 2 * (k     )    ] / (Zn[1 ] - Zn[0     ]);
			dz = dZn[ 0];
		}
		else if (k > Nz - 1) {
			fc = fpml[+ 2 * (k - Nz)    ] / (Zn[Nz] - Zn[Nz - 1]);
			dz = dZn[Nz];
		}
		else {
			fc = 0;
			dz = dZn[k];
		}
		feyz[k + ABC] = 1 / (1 + vdt * fc);
		deyz[k + ABC] = dz / epsr;
	}

	for (int i = -ABC; i < Nx + ABC + 1; i++) {
		float fc, dx;
		if      (i <      1) {
			fc = fpml[- 2 * (i     )    ] / (Xn[1 ] - Xn[0     ]);
			dx = dXn[ 0];
		}
		else if (i > Nx - 1) {
			fc = fpml[+ 2 * (i - Nx)    ] / (Xn[Nx] - Xn[Nx - 1]);
			dx = dXn[Nx];
		}
		else {
			fc = 0;
			dx = dXn[i];
		}
		feyx[i + ABC] = 1 / (1 + vdt * fc);
		deyx[i + ABC] = dx / epsr;
	}
}


// PML-Ez係数
void setupPmlEz(int ABC, int Nx, int Ny, float Dt, float Eps0,
	float *Xn, float *Yn, float *dXn, float *dYn,
	float *fpml, float *fezx, float *fezy, float *dezx, float *dezy)
{
	const float vdt = C * Dt / (float)sqrt(Eps0);
	const float epsr = Eps0;

	for (int i = -ABC; i < Nx + ABC + 1; i++) {
		float fc, dx;
		if      (i <      1) {
			fc = fpml[- 2 * (i     )    ] / (Xn[1 ] - Xn[0     ]);
			dx = dXn[ 0];
		}
		else if (i > Nx - 1) {
			fc = fpml[+ 2 * (i - Nx)    ] / (Xn[Nx] - Xn[Nx - 1]);
			dx = dXn[Nx];
		}
		else {
			fc = 0;
			dx = dXn[i];
		}
		fezx[i + ABC] = 1 / (1 + vdt * fc);
		dezx[i + ABC] = dx / epsr;
	}

	for (int j = -ABC; j < Ny + ABC + 1; j++) {
		float fc, dy;
		if      (j <      1) {
			fc = fpml[- 2 * (j     )    ] / (Yn[1 ] - Yn[0     ]);
			dy = dYn[ 0];
		}
		else if (j > Ny - 1) {
			fc = fpml[+ 2 * (j - Ny)    ] / (Yn[Ny] - Yn[Ny - 1]);
			dy = dYn[Ny];
		}
		else {
			fc = 0;
			dy = dYn[j];
		}
		fezy[j + ABC] = 1 / (1 + vdt * fc);
		dezy[j + ABC] = dy / epsr;
	}
}


// PML-Hx係数
void setupPmlHx(int ABC, int Ny, int Nz, float Dt, float Eps0,
	float *Yn, float *Zn, float *dYc, float *dZc,
	float *fpml, float *fhxy, float *fhxz, float *dhxy, float *dhxz)
{
	const float cdt = C * Dt / (float)sqrt(Eps0);
	const float amur = 1;  // 磁性体なし

	for (int j = -ABC; j < Ny + ABC + 0; j++) {
		float fc, dy;
		if      (j <      0) {
			fc = fpml[- 2 * (j     ) - 1] / (Yn[1 ] - Yn[0     ]);
			dy = dYc[     0];
		}
		else if (j > Ny - 1) {
			fc = fpml[+ 2 * (j - Ny) + 1] / (Yn[Ny] - Yn[Ny - 1]);
			dy = dYc[Ny - 1];
		}
		else {
			fc = 0;
			dy = dYc[j];
		}
		fhxy[j + ABC] = 1 / (1 + cdt * fc);
		dhxy[j + ABC] = dy / amur;
	}

	for (int k = -ABC; k < Nz + ABC + 0; k++) {
		float fc, dz;
		if      (k <      0) {
			fc = fpml[- 2 * (k     ) - 1] / (Zn[1 ] - Zn[0     ]);
			dz = dZc[     0];
		}
		else if (k > Nz - 1) {
			fc = fpml[+ 2 * (k - Nz) + 1] / (Zn[Nz] - Zn[Nz - 1]);
			dz = dZc[Nz - 1];
		}
		else {
			fc = 0;
			dz = dZc[k];
		}
		fhxz[k + ABC] = 1 / (1 + cdt * fc);
		dhxz[k + ABC] = dz / amur;
	}
}


// PML-Hy係数
void setupPmlHy(int ABC, int Nz, int Nx, float Dt, float Eps0,
	float *Zn, float *Xn, float *dZc, float *dXc,
	float *fpml, float *fhyz, float *fhyx, float *dhyz, float *dhyx)
{
	const float cdt = C * Dt / (float)sqrt(Eps0);
	const float amur = 1;  // 磁性体なし

	for (int k = -ABC; k < Nz + ABC + 0; k++) {
		float fc, dz;
		if      (k <      0) {
			fc = fpml[- 2 * (k     ) - 1] / (Zn[1 ] - Zn[0     ]);
			dz = dZc[     0];
		}
		else if (k > Nz - 1) {
			fc = fpml[+ 2 * (k - Nz) + 1] / (Zn[Nz] - Zn[Nz - 1]);
			dz = dZc[Nz - 1];
		}
		else {
			fc = 0;
			dz = dZc[k];
		}
		fhyz[k + ABC] = 1 / (1 + cdt * fc);
		dhyz[k + ABC] = dz / amur;
	}

	for (int i = -ABC; i < Nx + ABC + 0; i++) {
		float fc, dx;
		if      (i <      0) {
			fc = fpml[- 2 * (i     ) - 1] / (Xn[1 ] - Xn[0     ]);
			dx = dXc[     0];
		}
		else if (i > Nx - 1) {
			fc = fpml[+ 2 * (i - Nx) + 1] / (Xn[Nx] - Xn[Nx - 1]);
			dx = dXc[Nx - 1];
		}
		else {
			fc = 0;
			dx = dXc[i];
		}
		fhyx[i + ABC] = 1 / (1 + cdt * fc);
		dhyx[i + ABC] = dx / amur;
	}
}


// PML-Hz係数
void setupPmlHz(int ABC, int Nx, int Ny, float Dt, float Eps0,
	float *Xn, float *Yn, float *dXc, float *dYc,
	float *fpml, float *fhzx, float *fhzy, float *dhzx, float *dhzy)
{
	const float cdt = C * Dt / (float)sqrt(Eps0);
	const float amur = 1;  // 磁性体なし

	for (int i = -ABC; i < Nx + ABC + 0; i++) {
		float fc, dx;
		if      (i <      0) {
			fc = fpml[- 2 * (i     ) - 1] / (Xn[1 ] - Xn[0     ]);
			dx = dXc[     0];
		}
		else if (i > Nx - 1) {
			fc = fpml[+ 2 * (i - Nx) + 1] / (Xn[Nx] - Xn[Nx - 1]);
			dx = dXc[Nx - 1];
		}
		else {
			fc = 0;
			dx = dXc[i];
		}
		fhzx[i + ABC] = 1 / (1 + cdt * fc);
		dhzx[i + ABC] = dx / amur;
	}

	for (int j = -ABC; j < Ny + ABC + 0; j++) {
		float fc, dy;
		if      (j <      0) {
			fc = fpml[- 2 * (j     ) - 1] / (Yn[1 ] - Yn[0     ]);
			dy = dYc[     0];
		}
		else if (j > Ny - 1) {
			fc = fpml[+ 2 * (j - Ny) + 1] / (Yn[Ny] - Yn[Ny - 1]);
			dy = dYc[Ny - 1];
		}
		else {
			fc = 0;
			dy = dYc[j];
		}
		fhzy[j + ABC] = 1 / (1 + cdt * fc);
		dhzy[j + ABC] = dy / amur;
	}
}


// Ex
void pmlEx(int ABC, int Nx, int Ny, int Nz,
	float ***Ex, float ***Hy, float ***Hz, float ***Exy, float ***Exz,
	float *fexy, float *fexz, float *dexy, float *dexz)
{
	for (int i = -ABC + 0; i < Nx + ABC + 0; i++) {
	for (int j = -ABC + 1; j < Ny + ABC + 0; j++) {
	for (int k = -ABC + 1; k < Nz + ABC + 0; k++) {
		if ((i < 0) || (Nx - 1 < i) ||
		    (j < 0) || (Ny - 0 < j) ||
		    (k < 0) || (Nz - 0 < k)) {
			const float dhz = Hz[i     + ABC][j     + ABC][k     + ABC]
			                - Hz[i     + ABC][j - 1 + ABC][k     + ABC];
			Exy[i + ABC][j + ABC][k + ABC] = (
			Exy[i + ABC][j + ABC][k + ABC] + dexy[j + ABC] * dhz) * fexy[j + ABC];

			const float dhy = Hy[i     + ABC][j     + ABC][k     + ABC]
			                - Hy[i     + ABC][j     + ABC][k - 1 + ABC];
			Exz[i + ABC][j + ABC][k + ABC] = (
			Exz[i + ABC][j + ABC][k + ABC] - dexz[k + ABC] * dhy) * fexz[k + ABC];

			Ex[i + ABC][j + ABC][k + ABC] = Exy[i + ABC][j + ABC][k + ABC]
			                              + Exz[i + ABC][j + ABC][k + ABC];
		}
	}
	}
	}
}


// Ey
void pmlEy(int ABC, int Nx, int Ny, int Nz,
	float ***Ey, float ***Hz, float ***Hx, float ***Eyz, float ***Eyx,
	float *feyz, float *feyx, float *deyz, float *deyx)
{
	for (int i = -ABC + 1; i < Nx + ABC + 0; i++) {
	for (int j = -ABC + 0; j < Ny + ABC + 0; j++) {
	for (int k = -ABC + 1; k < Nz + ABC + 0; k++) {
		if ((i < 0) || (Nx - 0 < i) ||
		    (j < 0) || (Ny - 1 < j) ||
		    (k < 0) || (Nz - 0 < k)) {
			const float dhx = Hx[i     + ABC][j     + ABC][k     + ABC]
			                - Hx[i     + ABC][j     + ABC][k - 1 + ABC];
			Eyz[i + ABC][j + ABC][k + ABC] = (
			Eyz[i + ABC][j + ABC][k + ABC] + deyz[k + ABC] * dhx) * feyz[k + ABC];

			const float dhz = Hz[i     + ABC][j     + ABC][k     + ABC]
			                - Hz[i - 1 + ABC][j     + ABC][k     + ABC];
			Eyx[i + ABC][j + ABC][k + ABC] = (
			Eyx[i + ABC][j + ABC][k + ABC] - deyx[i + ABC] * dhz) * feyx[i + ABC];

			Ey[i + ABC][j + ABC][k + ABC] = Eyz[i + ABC][j + ABC][k + ABC]
			                              + Eyx[i + ABC][j + ABC][k + ABC];
		}
	}
	}
	}
}


// Ez
void pmlEz(int ABC, int Nx, int Ny, int Nz,
	float ***Ez, float ***Hx, float ***Hy, float ***Ezx, float ***Ezy,
	float *fezx, float *fezy, float *dezx, float *dezy)
{
	for (int i = -ABC + 1; i < Nx + ABC + 0; i++) {
	for (int j = -ABC + 1; j < Ny + ABC + 0; j++) {
	for (int k = -ABC + 0; k < Nz + ABC + 0; k++) {
		if ((i < 0) || (Nx - 0 < i) ||
		    (j < 0) || (Ny - 0 < j) ||
		    (k < 0) || (Nz - 1 < k)) {
			const float dhy = Hy[i     + ABC][j     + ABC][k     + ABC]
			                - Hy[i - 1 + ABC][j     + ABC][k     + ABC];
			Ezx[i + ABC][j + ABC][k + ABC] = (
			Ezx[i + ABC][j + ABC][k + ABC] + dezx[i + ABC] * dhy) * fezx[i + ABC];

			const float dhx = Hx[i     + ABC][j     + ABC][k     + ABC]
			                - Hx[i     + ABC][j - 1 + ABC][k     + ABC];
			Ezy[i + ABC][j + ABC][k + ABC] = (
			Ezy[i + ABC][j + ABC][k + ABC] - dezy[j + ABC] * dhx) * fezy[j + ABC];

			Ez[i + ABC][j + ABC][k + ABC] = Ezx[i + ABC][j + ABC][k + ABC]
			                              + Ezy[i + ABC][j + ABC][k + ABC];
		}
	}
	}
	}
}


// Hx
void pmlHx(int ABC, int Nx, int Ny, int Nz,
	float ***Hx, float ***Ey, float ***Ez, float ***Hxy, float ***Hxz,
	float *fhxy, float *fhxz, float *dhxy, float *dhxz)
{
	for (int i = -ABC + 1; i < Nx + ABC + 0; i++) {
	for (int j = -ABC + 0; j < Ny + ABC + 0; j++) {
	for (int k = -ABC + 0; k < Nz + ABC + 0; k++) {
		if ((i < 0) || (Nx - 0 < i) ||
		    (j < 0) || (Ny - 1 < j) ||
		    (k < 0) || (Nz - 1 < k)) {
			const float dez = Ez[i     + ABC][j + 1 + ABC][k     + ABC]
			                - Ez[i     + ABC][j     + ABC][k     + ABC];
			Hxy[i + ABC][j + ABC][k + ABC] = (
			Hxy[i + ABC][j + ABC][k + ABC] - (dhxy[j + ABC] * dez)) * fhxy[j + ABC];

			const float dey = Ey[i     + ABC][j     + ABC][k + 1 + ABC]
			                - Ey[i     + ABC][j     + ABC][k     + ABC];
			Hxz[i + ABC][j + ABC][k + ABC] = (
			Hxz[i + ABC][j + ABC][k + ABC] + (dhxz[k + ABC] * dey)) * fhxz[k + ABC];

			Hx[i + ABC][j + ABC][k + ABC] = Hxy[i + ABC][j + ABC][k + ABC]
		                                  + Hxz[i + ABC][j + ABC][k + ABC];
		}
	}
	}
	}
}


// Hy
void pmlHy(int ABC, int Nx, int Ny, int Nz,
	float ***Hy, float ***Ez, float ***Ex, float ***Hyz, float ***Hyx,
	float *fhyz, float *fhyx, float *dhyz, float *dhyx)
{
	for (int i = -ABC + 0; i < Nx + ABC + 0; i++) {
	for (int j = -ABC + 1; j < Ny + ABC + 0; j++) {
	for (int k = -ABC + 0; k < Nz + ABC + 0; k++) {
		if ((i < 0) || (Nx - 1 < i) ||
		    (j < 0) || (Ny - 0 < j) ||
		    (k < 0) || (Nz - 1 < k)) {
			const float dex = Ex[i     + ABC][j     + ABC][k + 1 + ABC]
			                - Ex[i     + ABC][j     + ABC][k     + ABC];
			Hyz[i + ABC][j + ABC][k + ABC] = (
			Hyz[i + ABC][j + ABC][k + ABC] - (dhyz[k + ABC] * dex)) * fhyz[k + ABC];

			const float dez = Ez[i + 1 + ABC][j     + ABC][k     + ABC]
			                - Ez[i     + ABC][j     + ABC][k     + ABC];
			Hyx[i + ABC][j + ABC][k + ABC] = (
			Hyx[i + ABC][j + ABC][k + ABC] + (dhyx[i + ABC] * dez)) * fhyx[i + ABC];

			Hy[i + ABC][j + ABC][k + ABC] = Hyz[i + ABC][j + ABC][k + ABC]
		                                  + Hyx[i + ABC][j + ABC][k + ABC];
		}
	}
	}
	}
}


// Hz
void pmlHz(int ABC, int Nx, int Ny, int Nz,
	float ***Hz, float ***Ex, float ***Ey, float ***Hzx, float ***Hzy,
	float *fhzx, float *fhzy, float *dhzx, float *dhzy)
{
	for (int i = -ABC + 0; i < Nx + ABC + 0; i++) {
	for (int j = -ABC + 0; j < Ny + ABC + 0; j++) {
	for (int k = -ABC + 1; k < Nz + ABC + 0; k++) {
		if ((i < 0) || (Nx - 1 < i) ||
		    (j < 0) || (Ny - 1 < j) ||
		    (k < 0) || (Nz - 0 < k)) {
			const float dey = Ey[i + 1 + ABC][j     + ABC][k     + ABC]
			                - Ey[i     + ABC][j     + ABC][k     + ABC];
			Hzx[i + ABC][j + ABC][k + ABC] = (
			Hzx[i + ABC][j + ABC][k + ABC] - (dhzx[i + ABC] * dey)) * fhzx[i + ABC];

			const float dex = Ex[i     + ABC][j + 1 + ABC][k     + ABC]
			                - Ex[i     + ABC][j     + ABC][k     + ABC];
			Hzy[i + ABC][j + ABC][k + ABC] = (
			Hzy[i + ABC][j + ABC][k + ABC] + (dhzy[j + ABC] * dex)) * fhzy[j + ABC];

			Hz[i + ABC][j + ABC][k + ABC] = Hzx[i + ABC][j + ABC][k + ABC]
		                                  + Hzy[i + ABC][j + ABC][k + ABC];
		}
	}
	}
	}
}
