/*
writedata.c
*/

#include <stdlib.h>
#include <stdio.h>
#include <math.h>
#include <assert.h>

extern void getminmax4f(int, int, int, int, int, int, int, int, int, float ****, double *, double *);

extern float C;

// ファイル出力
void writedata(const char fn[], int Ndata, int Nx, int Ny, int Nz, int Nout, int NTx, int NRx, int NFreq, const float Freq[],
	float ****Epsr, float ****Sigm, float ****S_r, float ****S_i, int Sdif, int size1, int size2)
{
	// open
	FILE *fp;
	if ((fp = fopen(fn, "wb")) == NULL) {
		printf("%s open error\n", fn);
		return;
	}

	// image, データ0との差分をとる
	if (Sdif) {
		for (int n = 1; n < Ndata; n++) {
			for (int ifreq = 0; ifreq < NFreq; ifreq++) {
			for (int itx = 0; itx < NTx; itx++) {
			for (int irx = 0; irx < NRx; irx++) {
				S_r[n][ifreq][itx][irx] -= S_r[0][ifreq][itx][irx];
				S_i[n][ifreq][itx][irx] -= S_i[0][ifreq][itx][irx];
			}
			}
			}
		}
		// データ0=0
		for (int ifreq = 0; ifreq < NFreq; ifreq++) {
		for (int itx = 0; itx < NTx; itx++) {
		for (int irx = 0; irx < NRx; irx++) {
			S_r[0][ifreq][itx][irx] = 0;
			S_i[0][ifreq][itx][irx] = 0;
		}
		}
		}
	}

	// label, 導電率->比誘電率虚部 因子
	const double pi = 4 * atan(1);
	const double freq = (Freq[0] + Freq[NFreq - 1]) / 2;  // 中心周波数
	const double label2_factor = (C * C * 4 * pi * 1e-7) / (2 * pi * freq);

	// label, 誘電率分布(内部領域)
	const int i0 = Nout;
	const int i1 = Nx - Nout;
	const int j0 = Nout;
	const int j1 = Ny - Nout;
	const int k0 = Nout;
	const int k1 = Nz - Nout;

	// image, 最小値・最大値
	double image1_min, image1_max, image2_min, image2_max;
	getminmax4f(0, Ndata, 0, NFreq, 0, NTx, 0, NRx, 0, S_r, &image1_min, &image1_max);
	getminmax4f(0, Ndata, 0, NFreq, 0, NTx, 0, NRx, 0, S_i, &image2_min, &image2_max);
	//printf("%f %f %f %f\n", image1_min, image1_max, image2_min, image2_max);

	// label, 最小値・最大値
	double label1_min, label1_max, label2_min, label2_max;
	getminmax4f(0, Ndata, i0, i1, j0, j1, k0, k1, 0, Epsr, &label1_min, &label1_max);
	getminmax4f(0, Ndata, i0, i1, j0, j1, k0, k1, 0, Sigm, &label2_min, &label2_max);
	label2_min *= label2_factor;
	label2_max *= label2_factor;
	//printf("%f %f %f %f\n", label1_min, label1_max, label2_min, label2_max);

	// 整数データ
	int idata[9];
	idata[0] = Ndata;
	idata[1] = NFreq;
	idata[2] = NTx;
	idata[3] = NRx;
	idata[4] = i1 - i0;  // Mx
	idata[5] = j1 - j0;  // My
	idata[6] = k1 - k0;  // Mz
	idata[7] = size1;
	idata[8] = size2;
	fwrite(idata, sizeof(int), 9, fp);

	// 実数データ
	float fdata[8];
	fdata[0] = (float)image1_min;
	fdata[1] = (float)image1_max;
	fdata[2] = (float)image2_min;
	fdata[3] = (float)image2_max;
	fdata[4] = (float)label1_min;
	fdata[5] = (float)label1_max;
	fdata[6] = (float)label2_min;
	fdata[7] = (float)label2_max;
	fwrite(fdata, sizeof(float), 8, fp);

	// (1) image: S行列画像

	const int nimage = 2 * NFreq * NTx * NRx;
	if      (size1 == 4) {
		// f4
		float *image1d = (float *)malloc(nimage * sizeof(float));
		for (int n = 0; n < Ndata; n++) {
			// 1D配列化
			int iimage = 0;
			for (int ifreq = 0; ifreq < NFreq; ifreq++) {
			for (int itx = 0; itx < NTx; itx++) {
			for (int irx = 0; irx < NRx; irx++) {
				image1d[iimage++] = S_r[n][ifreq][itx][irx];
				image1d[iimage++] = S_i[n][ifreq][itx][irx];
			}
			}
			}
			assert(iimage == nimage);
			// 出力, データ毎
			fwrite(image1d, sizeof(float), nimage, fp);
		}
		free(image1d);
	}
	else if (size1 == 2) {
		// u2
		unsigned short *image1d = (unsigned short *)malloc(nimage * sizeof(unsigned short));
		for (int n = 0; n < Ndata; n++) {
			// 1D配列化+2バイト化
			int iimage = 0;
			for (int ifreq = 0; ifreq < NFreq; ifreq++) {
			for (int itx = 0; itx < NTx; itx++) {
			for (int irx = 0; irx < NRx; irx++) {
				image1d[iimage++] = (unsigned short)(65535 * (S_r[n][ifreq][itx][irx] - image1_min) / (image1_max - image1_min));
				image1d[iimage++] = (unsigned short)(65535 * (S_i[n][ifreq][itx][irx] - image2_min) / (image2_max - image2_min));
			}
			}
			}
			assert(iimage == nimage);
			// 出力, データ毎
			fwrite(image1d, sizeof(unsigned short), nimage, fp);
		}
		free(image1d);
	}
	else if (size1 == 1) {
		// u1
		unsigned char *image1d = (unsigned char *)malloc(nimage * sizeof(unsigned char));
		for (int n = 0; n < Ndata; n++) {
			// 1D配列化+1バイト化
			int iimage = 0;
			for (int ifreq = 0; ifreq < NFreq; ifreq++) {
			for (int itx = 0; itx < NTx; itx++) {
			for (int irx = 0; irx < NRx; irx++) {
				image1d[iimage++] = (unsigned char)(255 * (S_r[n][ifreq][itx][irx] - image1_min) / (image1_max - image1_min));
				image1d[iimage++] = (unsigned char)(255 * (S_i[n][ifreq][itx][irx] - image2_min) / (image2_max - image2_min));
			}
			}
			}
			assert(iimage == nimage);
			// 出力, データ毎
			fwrite(image1d, sizeof(unsigned char), nimage, fp);
		}
		free(image1d);
	}

	// (2) label: 誘電率分布

	const int nlabel = 2 * (i1 - i0) * (j1 - j0) * (k1 - k0);
	if      (size2 == 4) {
		// f4
		float *label1d = (float *)malloc(nlabel * sizeof(float));
		for (int n = 0; n < Ndata; n++) {
			// 1D配列化
			int ilabel = 0;
			for (int i = i0; i < i1; i++) {
			for (int j = j0; j < j1; j++) {
			for (int k = k0; k < k1; k++) {
				const float e1 = Epsr[n][i][j][k];
				const float e2 = Sigm[n][i][j][k] * (float)label2_factor;
				label1d[ilabel++] = e1;
				label1d[ilabel++] = e2;
			}
			}
			}
			assert(ilabel == nlabel);
			// 出力, データ毎
			fwrite(label1d, sizeof(float), nlabel, fp);
		}
		free(label1d);
	}
	else if (size2 == 2) {
		// u2
		unsigned short *label1d = (unsigned short *)malloc(nlabel * sizeof(unsigned short));
		for (int n = 0; n < Ndata; n++) {
			// 1D配列化+2バイト化
			int ilabel = 0;
			for (int i = i0; i < i1; i++) {
			for (int j = j0; j < j1; j++) {
			for (int k = k0; k < k1; k++) {
				const float e1 = Epsr[n][i][j][k];
				const float e2 = Sigm[n][i][j][k] * (float)label2_factor;
				label1d[ilabel++] = (unsigned short)(65535 * (e1 - label1_min) / (label1_max - label1_min));
				label1d[ilabel++] = (unsigned short)(65535 * (e2 - label2_min) / (label2_max - label2_min));
			}
			}
			}
			assert(ilabel == nlabel);
			// 出力, データ毎
			fwrite(label1d, sizeof(unsigned short), nlabel, fp);
		}
		free(label1d);
	}
	else if (size2 == 1) {
		// u1
		unsigned char *label1d = (unsigned char *)malloc(nlabel * sizeof(unsigned char));
		for (int n = 0; n < Ndata; n++) {
			// 1D配列化+1バイト化
			int ilabel = 0;
			for (int i = i0; i < i1; i++) {
			for (int j = j0; j < j1; j++) {
			for (int k = k0; k < k1; k++) {
				const float e1 = Epsr[n][i][j][k];
				const float e2 = Sigm[n][i][j][k] * (float)label2_factor;
				label1d[ilabel++] = (unsigned char)(255 * (e1 - label1_min) / (label1_max - label1_min));
				label1d[ilabel++] = (unsigned char)(255 * (e2 - label2_min) / (label2_max - label2_min));
			}
			}
			}
			assert(ilabel == nlabel);
			// 出力, データ毎
			fwrite(label1d, sizeof(unsigned char), nlabel, fp);
		}
		free(label1d);
	}

	// close
	fclose(fp);
}
