# -*- coding: utf-8 -*-
"""
plotutils.py
汎用図形出力関数
"""

import math
#import numpy as np
import matplotlib.pyplot as plt

# 等高線図
# figtitle : タイトル
# figsize : ウィンドウサイズ(inch)
# mx, my, mstep : 横の数,　縦の数, 関数配列のステップ数
# f[ndata, nx, ny] : 関数配列
# sta[ndata] : タイトル配列
# suptitle : ページタイトル
def contour(figtitle, figsize, mx, my, mstep, f, vmin, vmax, sta, suptitle, transpose=False, origin='lower', cmap='rainbow', levels=10):
    assert f.ndim == 3
    fig = plt.figure(figtitle, figsize=figsize)

    num = 0
    for _ in range(mx):
        for _ in range(my):
            fid = (num + 1) * mstep - 1
            if (fid < f.shape[0]):
                ax = plt.subplot(my, mx, num + 1)
                g = f[fid]
                if transpose:
                    g = g.T  # 縦横変換
                #ax.imshow(g, vmin=vmin, vmax=vmax, interpolation=interpolation, origin=origin, cmap=cmap)
                ax.contourf(g, vmin=vmin, vmax=vmax, origin=origin, cmap=cmap, levels=levels)
                #ax.contour(g, vmin=vmin, vmax=vmax, origin=origin, cmap=cmap, levels=levels)
                ax.set_aspect('equal')
                ax.set_axis_off()
                if sta is not None:
                    ax.set_title(sta[fid], fontsize=8, pad=0)
                num += 1

    if suptitle is not None:
        plt.suptitle(suptitle, fontsize=10)

    fig.tight_layout()
    plt.show()

# 等高線図, 各2枚
def contour2(figtitle, figsize, pair, mx, dnum, f1, f2, vmin, vmax, sta1, sta2, suptitle, transpose=False, origin='lower', cmap='rainbow', levels=10):
    #print(f1.shape, f2.shape)
    assert f1.ndim == f2.ndim == 3
    assert f1.shape == f2.shape
    fig = plt.figure(figtitle, figsize=figsize)

    # 図形表示データ数
    nfig = math.ceil((dnum[1] + dnum[2] - dnum[0]) / dnum[2])
    
    # mx x my : 横 x 縦 データ数
    my = math.ceil(nfig / mx)

    # nx x ny : 横 x 縦 図数
    nx = mx * (2 if pair == 0 else 1)
    ny = my * (1 if pair == 0 else 2)
    #print(dnum, nfig, mx, my, nx, ny)
    #print(vmin, vmax)

    fid = dnum[0] - 1
    for iy in range(my):
        for ix in range(mx):
            if (fid < len(f1)) and (fid < dnum[1]):
                # 1
                pos = nx * iy * (1 if pair == 0 else 2) + ix * (2 if pair == 0 else 1) + 1
                ax1 = plt.subplot(ny, nx, pos)
                g1 = f1[fid]
                if transpose:
                    g1 = g1.T
                #ax1.imshow(g1, vmin=vmin, vmax=vmax, origin=origin, cmap=cmap, interpolation='auto')
                ax1.contourf(g1, vmin=vmin, vmax=vmax, origin=origin, cmap=cmap, levels=levels)
                #ax1.contour(g1, vmin=vmin, vmax=vmax, origin=origin, cmap=cmap, levels=levels)
                ax1.set_aspect('equal')
                ax1.set_axis_off()
                if sta1 is not None:
                    ax1.set_title(sta1[fid], fontsize=8, pad=0, color='k') # 黒

                # 2
                pos += 1 if pair == 0 else nx
                ax2 = plt.subplot(ny, nx, pos)
                g2 = f2[fid]
                if transpose:
                    g2 = g2.T
                #ax2.imshow(g2, vmin=vmin, vmax=vmax, origin=origin, cmap=cmap, interpolation='auto')
                ax2.contourf(g2, vmin=vmin, vmax=vmax, origin=origin, cmap=cmap, levels=levels)
                #ax2.contour(g2, vmin=vmin, vmax=vmax, origin=origin, cmap=cmap, levels=levels)
                ax2.set_aspect('equal')
                ax2.set_axis_off()
                if sta2 is not None:
                    ax2.set_title(sta2[fid], fontsize=8, pad=0, color='r') # 赤

            fid += dnum[2]

    if suptitle is not None:
        plt.suptitle(suptitle, fontsize=10)

    fig.tight_layout()
    plt.show()
