# -*- coding: utf-8 -*-
"""
post.py
計算結果を図形出力する
"""

import os, datetime
#import numpy as np

import utils, plot

def main():
    
    # 検証データのラベルの正解と予測をファイルから読み込む
    outfile = 'dlspa.npz'
    idata, trues, preds, ecomp = utils.load_label(outfile)
    #print(idata)
    Nx = idata[4]
    Ny = idata[5]
    Nz = idata[6]  # fdtd2dでは1

    # ファイル更新日時
    dt = datetime.datetime.fromtimestamp(os.path.getmtime(outfile)).strftime('%Y/%m/%d %H:%M:%S')

    # 1D->5D配列
    mlabel = (2 if ecomp == 3 else 1)
    trues = trues.reshape(-1, mlabel, Nx, Ny, Nz)
    preds = preds.reshape(-1, mlabel, Nx, Ny, Nz)
    #print(ecomp, mlabel, trues.shape, preds.shape)
    assert trues.shape == preds.shape

    # label, 2D等高線図
    if Nz == 1:
        # fdtd2d
        plot.plot2d_labels_2d(trues, preds, dt)
    else:
        # fdtd3d
        plot.plot2d_labels_3d(trues, preds, dt)

    # label, ヒストグラム
    #plot.histogram2(trues, preds, bins=30, range=(30, 60))

    # label, 3D分布図 (fdtd3d)
    """
    if Nz > 1:
        idata = 0  # データ番号, 適当に代入する
        idata = max(0, min(idata, trues.shape[0] - 1))
        vmin = min(np.min(trues[idata]), np.min(preds[idata]))
        vmax = max(np.max(trues[idata]), np.max(preds[idata]))
        plot.plot3d_labels('label (true) data#=%d' % (idata + 1), trues[idata], vmin, vmax)
        plot.plot3d_labels('label (pred) data#=%d' % (idata + 1), preds[idata], vmin, vmax)
    """

if __name__ == "__main__":
    main()
